--
-- Sieczkarnia 
-- Autor/Author: Dawider
-- Data/Date: 20.08.2013
-- 

Sieczkarnia = {};

function Sieczkarnia.prerequisitesPresent(specializations)
	return true;
end;

function Sieczkarnia:load(xmlFile)

    self.kolo1Nodes = {};

    local kolo1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolo1#index"));
    if kolo1Node ~= nil then
        local speed = 0.003*3;
        table.insert(self.kolo1Nodes, {node=kolo1Node, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.kologlowny.kolo1(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local kolo1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if kolo1Node ~= nil then
            table.insert(self.kolo1Nodes, {node=kolo1Node, speed=speed});
        end;
        i = i + 1;
    end;
	
	local kola = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kola#index"));
	if kola ~= nil then
		self.kola = kola;
	end;
	
	local rozkladanie = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rozkladanie#index"));
	if rozkladanie ~= nil then
		self.rozkladanie = rozkladanie;
	end;	
	

	local drzwi = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi#index"));
	if drzwi ~= nil then
		self.drzwi = drzwi;
	end;
	
	
end;

function Sieczkarnia:delete()
end;

function Sieczkarnia:keyEvent(unicode, sym, modifier, isDown)
end;
	
function Sieczkarnia:update(dt)

        local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);



		local px, py, pz = getWorldTranslation(self.rozkladanie); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.przyrozkladaniu = true; 
		else
			self.przyrozkladaniu = false; 
		end;	
		
		local tx, ty, tz = getWorldTranslation(self.drzwi); 
		local distance = Utils.vector3Length(tx-vx, ty-vy, tz-vz);	
		if distance < nearestDistance then
			self.przydrzwi = true; 
		else
			self.przydrzwi = false; 
		end;		
		
		

	if self.przyrozkladaniu then	
		if InputBinding.hasEvent(InputBinding.rozk) then
			if self.animationParts[16].clipEndTime then
				self:setAnimationTime(16, self.animationParts[16].offSet);
			elseif self.animationParts[16].clipStartTime then
				self:setAnimationTime(16, self.animationParts[16].animDuration);
			end;
		end;	
	end;	
	

	
	if self:getIsActiveForInput(false) or self.przydrzwi then
	 	if InputBinding.isPressed(InputBinding.drzwiw) then
               self:setAnimationTime(17, self.animationParts[17].currentPosition+(self.animationParts[17].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.drzwin) then
               self:setAnimationTime(17, self.animationParts[17].currentPosition-(self.animationParts[17].offSet+dt), false);
        end;
	end;
	
	if self:getIsActiveForInput(false) then
	 	if InputBinding.isPressed(InputBinding.oknoroz) then
               self:setAnimationTime(18, self.animationParts[18].currentPosition+(self.animationParts[18].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.oknozwi) then
               self:setAnimationTime(18, self.animationParts[18].currentPosition-(self.animationParts[18].offSet+dt), false);
        end;
	end;	
	
	
	
	if self.przyrozkladaniu then
		if self.animationParts[16].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Zloz (Gdy jest widoczna)", InputBinding.getKeyNamesOfDigitalAction(InputBinding.rozk)));
 		else
			g_currentMission:addExtraPrintText(string.format("%s: Rozloz (Gdy jest widoczna)", InputBinding.getKeyNamesOfDigitalAction(InputBinding.rozk)));
		end;
 	end;
	
	if self.przydrzwi then
		if self.animationParts[16].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("Drzwi 5/6", InputBinding.getKeyNamesOfDigitalAction(InputBinding.drzwiw)));
 		else
			g_currentMission:addExtraPrintText(string.format("Drzwi 5/6", InputBinding.getKeyNamesOfDigitalAction(InputBinding.drzwin)));
		end;
 	end;	
	
--INNE
			if self.chopperActive then
				for _, kolo1Node in pairs(self.kolo1Nodes) do
					rotate(kolo1Node.node, -dt*kolo1Node.speed, 0, 0);
				end;
			end;
			
end;	

function Sieczkarnia:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sieczkarnia:draw()
end;