--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @date  24/05/09


sieczkarnia = {};

function sieczkarnia.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function sieczkarnia:load(xmlFile)
	self.setsieczkarniaActive = SpecializationUtil.callSpecializationsFunction("setsieczkarniaActive");

   

    -- Straw Active Boolean
    self.strawActive = true;
	
	
end;

function sieczkarnia:readStream(streamId, connection)
	self:setsieczkarniaActive(streamReadBool(streamId), true);
end;

function sieczkarnia:writeStream(streamId, connection)
	streamWriteBool(streamId, self.strawActive);
end;

function sieczkarnia:delete()
end;

function sieczkarnia:mouseEvent(posX, posY, isDown, isUp, button)
end;

function sieczkarnia:keyEvent(unicode, sym, modifier, isDown)
end;

function sieczkarnia:update(dt)
    -- Check for input
	if self:getIsActiveForSound() then
		if InputBinding.hasEvent(InputBinding.sieczkar) then
		    self:setsieczkarniaActive(not self.strawActive);
		end;
    end;
	-- Check if straw is enabled
	if not self.strawActive then
		self.strawEmitState = false;
		self.strawEnableTime = nil;
		self.chopperActivated = true;
		self.chopperBlind = nil;
			
		
					
		-- Enable chopper particle system					
		if self.lastArea > 0 then
			if self.chopperActivated then
				if self.chopperEnableTime == nil then
					self.chopperEnableTime = self.time + self.chopperToggleTime;
				else
					self.chopperDisableTime = nil;
				end;
				disableChopperEmit = false;
			end;
			
			-- Chopper starting delay
			if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
				self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
				if self.currentChopperParticleSystem == nil then
					self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
				end;
				Utils.setEmittingState(self.currentChopperParticleSystem, true);
			end;
		end;	
	elseif self.strawActive then
		self.chopperBlind = self.backupChopperBlind;
	end;
end;

function sieczkarnia:draw()
end;

function sieczkarnia:setsieczkarniaActive(isActive, noEventSend)
	self.strawActive = isActive;
	if noEventSend ~= true then
		sieczkarniaEvent.sendEvent(self, isActive);
	end;
	
end;