--
-- heder_bizon
-- @author  Speedy
-- @date  26/07/11
--
-- Copyright (C) Speedy & MarTini, All Rights Reserved.


heder_bizon = {};

function heder_bizon.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function heder_bizon:load(xmlFile)
	---------------------------Motowidla gora/dol--------------------------------------------------
		local widelkiNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.widelki#index"));
		if widelkiNode ~= nil then
        self.widelki = {};
        self.widelki.node = widelkiNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.widelki#minRot"));
        self.widelki.minRot = {};
        self.widelki.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.widelki.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.widelki.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.widelki#maxRot"));
        self.widelki.maxRot = {};
        self.widelki.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.widelki.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.widelki.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.widelki.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.widelki#rotTime"), 2)*1000;
        self.widelki.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.widelki#touchRotLimit"), 10));
    end;
	
------------------------------Motowidla przod/tyl----------------------------------------------
		local translationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motowidla_przod_tyl#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motowidla_przod_tyl#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motowidla_przod_tyl#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motowidla_przod_tyl#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motowidla_przod_tyl#touchTransLimit"), 10);
    end;
    
		local rotationPartNoderuchwal2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ruchwal#index"));
   	if rotationPartNoderuchwal2 ~= nil then
        self.rotationPartruchwal2 = {};
        self.rotationPartruchwal2.node = rotationPartNoderuchwal2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartruchwal#minRot"));
        self.rotationPartruchwal2.minRot = {};
        self.rotationPartruchwal2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchwal2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchwal2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchwal#maxRot"));
        self.rotationPartruchwal2.maxRot = {};
        self.rotationPartruchwal2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchwal2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchwal2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchwal2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchwal#rotTime"), 2)*1000;
        self.rotationPartruchwal2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchwal#touchRotLimit"), 10));
    end;
    
    	local rotationPartNoderuchkosa2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ruchkosa#index"));
   	if rotationPartNoderuchkosa2 ~= nil then
        self.rotationPartruchkosa2 = {};
        self.rotationPartruchkosa2.node = rotationPartNoderuchkosa2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartruchkosa#minRot"));
        self.rotationPartruchkosa2.minRot = {};
        self.rotationPartruchkosa2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchkosa2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchkosa2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchkosa#maxRot"));
        self.rotationPartruchkosa2.maxRot = {};
        self.rotationPartruchkosa2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchkosa2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchkosa2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchkosa2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchkosa#rotTime"), 2)*1000;
        self.rotationPartruchkosa2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchkosa#touchRotLimit"), 10));
    end;
    
	self.motowidlaNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motowidla#index"));
	self.slimakNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
	self.kolko1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolko1#index"));
	self.kolko2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolko2#index"));
	self.kolko3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolko3#index"));
	self.kolko4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolko4#index"));
	local indexDrucikiStr = getXMLString(xmlFile, "vehicle.druciki#index");
	self.drucikiCount = getXMLInt(xmlFile, "vehicle.druciki#count");
	self.drucikiRootNode = Utils.indexToObject(self.components, indexDrucikiStr);
------------------------------PS Zboze----------------------------------------
	self.zboze = {};
    local zbozeCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.zboze#count"), 0);
    for i=1, zbozeCount do
        local namei = string.format("vehicle.zboze.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.zboze, namei, nodei, false, nil, self.baseDirectory)			
    end;


	self.predkosc_hedera = 0.001;
	self.test = 300;
end;
function heder_bizon:delete()
Utils.deleteParticleSystem(self.zboze);
end;

function heder_bizon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function heder_bizon:keyEvent(unicode, sym, modifier, isDown)
-------------------------Motowidla gora/dol------------------------------
	if sym == Input.KEY_KP_8 then
		self.widelkiMax = isDown;	
	end;
	if sym == Input.KEY_KP_2 then
		self.widelkiMin = isDown;		
	end;
------------------------------Motowidla przod/tyl---------------------------	
	if sym == Input.KEY_KP_6 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.translationMin = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.szybciej = isDown;	
	end;
	if sym == Input.KEY_pagedown then
		self.wolniej = isDown;		
	end;
if isDown and sym == Input.KEY_KP_9 then
		self.ruchwal = not self.ruchwal;
	end;
end;

function heder_bizon:update(dt)
	----------------Motowidla gora/dol-----------------------------------------------
local doRotate = self.widelkiMax or self.widelkiMin 
	if self.widelki ~= nil and doRotate then
        	local x, y, z = getRotation(self.widelki.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.widelki.maxRot, self.widelki.minRot, 3, self.widelki.rotTime, dt, not self.widelkiMax);
        	setRotation(self.widelki.node, unpack(newRot));
	end;  
---------------Motowidla przod/tyl-----------------------------------------------
local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
		
	if self.szybciej then		
		if self.predkosc_hedera < 0.003 then
			self.predkosc_hedera = self.predkosc_hedera + 0.0001;
		end;	
	end;
	if self.wolniej then
		if self.predkosc_hedera > 0.001 then
			self.predkosc_hedera = self.predkosc_hedera - 0.0001;
		end;
	end;
		
	if self.reelStarted then
		rotate(self.slimakNode, -dt*self.predkosc_hedera*3, 0, 0);
		rotate(self.kolko1Node, -dt*self.predkosc_hedera*3, 0, 0);
		rotate(self.kolko2Node, -dt*self.predkosc_hedera*3, 0, 0);
		rotate(self.kolko3Node, -dt*self.predkosc_hedera*2, 0, 0);
		rotate(self.kolko4Node, -dt*self.predkosc_hedera*2, 0, 0);
		if self.motowidlaNode ~= nil then
			rotate(self.motowidlaNode, -dt*self.predkosc_hedera, 0, 0);
			atx, aty, atz = getRotation(self.motowidlaNode);
			for i=1, self.drucikiCount do
				local drucik = getChildAt(self.drucikiRootNode, i-1);
				tx, ty, tz = getRotation(drucik);
				setRotation(drucik, -atx, aty, atz);
		self.ruchwal = true;
		self.ruchkosa = true;
	if self.ruchwal then
		self.test = self.test - dt;
		if self.test < 0 then
				self.rotationMaxruchwal2 = not self.rotationMaxruchwal2;
				self.rotationMaxruchkosa2 = not self.rotationMaxruchkosa2;
			self.test = 300;
		end;
	end;
if self.rotationPartruchwal2 ~= nil then
		local x, y, z = getRotation(self.rotationPartruchwal2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchwal2.maxRot, self.rotationPartruchwal2.minRot, 3, self.rotationPartruchwal2.rotTime, dt, not self.rotationMaxruchwal2);
		setRotation(self.rotationPartruchwal2.node, unpack(newRot));
   end;
if self.rotationPartruchkosa2 ~= nil then
		local x, y, z = getRotation(self.rotationPartruchkosa2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchkosa2.maxRot, self.rotationPartruchkosa2.minRot, 3, self.rotationPartruchkosa2.rotTime, dt, not self.rotationMaxruchkosa2);
		setRotation(self.rotationPartruchkosa2.node, unpack(newRot));
   end;
			end;
		end;
		
	end;		
	Utils.setEmittingState(self.zboze, (self.reelStarted and self.lastAreaBiggerZero));

end;

function heder_bizon:draw()
end;

