--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.25, 0.02, "");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.25, 0.02, "Wcisnij Numpad 0: Info");
		renderText(0.72, 0.86, 0.025, "- Bizon Rekord ZO 58 info -");			
		renderText(0.72, 0.81, 0.02, "Numpad 8: Drzwi ");
		renderText(0.72, 0.79, 0.02, "Numpad 7: Okno");			
		renderText(0.72, 0.77, 0.02, "m: Klapa zbiornika zboza");
		renderText(0.72, 0.75, 0.02, "z: Rozloz sieczkarnie");
		renderText(0.72, 0.73, 0.02, "x: Wlacz sieczkarnie");
		renderText(0.72, 0.71, 0.02, "Numpad 1: Lewy kierunkowsakz");
		renderText(0.72, 0.69, 0.02, "Numpad 2: Swiatla awaryjne");
		renderText(0.72, 0.67, 0.02, "Numpad 3: Prawy kierunkowskaz");
		renderText(0.72, 0.65, 0.02, "Numpad 5: Swiatla robocze");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




