--
-- BirchwoodMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BirchwoodMap = {}

local BirchwoodMap_mt = Class(BirchwoodMap, Mission00);


function BirchwoodMap:new(baseDirectory, customMt)
    FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("map/huds/oatHud.dds", baseDirectory), {2,0,1,1});
     FruitUtil.registerFruitType("rye", g_i18n:getText("rye"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("map/huds/ryeHud.dds", baseDirectory), {2,0,0.1,1});
     FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_OAT, "oat_windrow", g_i18n:getText("oat_windrow"), 0.2, 3, false, Utils.getFilename("map/huds/oatWindrow.dds", baseDirectory));
    local mt = customMt;
    if mt == nil then
        mt = BirchwoodMap_mt;
    end;
    local self = BirchwoodMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function BirchwoodMap:delete()
    BirchwoodMap:superClass().delete(self);
end;

function BirchwoodMap:load()


	
    self:startLoadingTask();
	
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function BirchwoodMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("BirchwoodMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 896, -34, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 646, 220, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 906, -35, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 884, -325, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	-- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 338, -257, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 703, 211, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 657, 567, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 813, -252, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- egg sellpoint
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 792, 396, iconSize, iconSize * (4 / 3), false, false, false, 0, true); 


    BirchwoodMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
	

	
end;

function BirchwoodMap:onStartMission()
    BirchwoodMap:superClass().onStartMission(self);
end;

function BirchwoodMap:mouseEvent(posX, posY, isDown, isUp, button)
   BirchwoodMap :superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BirchwoodMap:keyEvent(unicode, sym, modifier, isDown)
    BirchwoodMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BirchwoodMap:update(dt)
    BirchwoodMap:superClass().update(self, dt);
end;

function BirchwoodMap:draw()
    BirchwoodMap:superClass().draw(self);
end;