--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/eg/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
	
    self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs


    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 + 632, 1024 + 584, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 662, 1024 + 603, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 644, 1024 + 509, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 642, 1024 + 463, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 + 585, 0 + 497, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

	-- Eggs
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("huds/hud_pda_spot_eggs.png", self.baseDirectory), 0 + 636, 0 + 598, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- water
    self.missionPDA:createMapHotspot("water", Utils.getFilename("huds/hud_pda_spot_water.png", self.baseDirectory), 0 + 598, 0 + 453, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

 	--wolle
    self.missionPDA:createMapHotspot("wolle", Utils.getFilename("huds/hud_pda_spot_wolle.png", self.baseDirectory), 0 + 323, 0 - 748, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    --Kraftwerk
    self.missionPDA:createMapHotspot("Kraftwerk", Utils.getFilename("huds/hud_pda_spot_kraftwerk.png", self.baseDirectory), 0 + 653, 0 + 533, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    --Glle
    self.missionPDA:createMapHotspot("Glle", Utils.getFilename("huds/hud_pda_spot_liquidmanure.png", self.baseDirectory), 0 + 588, 0 + 569, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    --Mist
    self.missionPDA:createMapHotspot("Mist", Utils.getFilename("huds/hud_pda_spot_manure.png", self.baseDirectory), 0 + 588, 0 + 541, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	--Milk
    self.missionPDA:createMapHotspot("Milk", Utils.getFilename("huds/hud_pda_spot_milk.png", self.baseDirectory), 0 + 599, 0 + 529, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 888.8 , 1024 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 1024 + 527, 1024 + 566, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 1024 + 629, 1024 + 410, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 1024 + 632, 1024 + 559, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;