--
-- Autor: Siwus
-- Specialization for sprayer
--


TSW = {};

function TSW.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations) ;
	end;


function TSW:load(xmlFile)
	self.PlaneNodeO = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Plane#index1"));
	self.PlaneNodeC = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Plane#index2"));

	self.szerokosc = 36;
	self.literPerHa = 20000;
end;


function TSW:update(dt)
	if self.attacherVehicle then
		if self.isTurnedOn then			
			local literPercentage = self.literPerHa / 350;
			local widthPercentage = self.szerokosc/42; -- x/42
			local speedPercentage = math.max(1, ((self.lastSpeed * 3600) / 15));			
			self.sprayLitersPerSecond[self.currentFillType] = 3.78 * literPercentage * widthPercentage * speedPercentage;
		end;
	end;
	
	self.zapelnienie = self.fillLevel/self.capacity;
	if self.zapelnienie <= 0.9 then
		setVisibility(self.PlaneNodeO, false);
		setVisibility(self.PlaneNodeC, true);
	else
		setVisibility(self.PlaneNodeO, true);
		setVisibility(self.PlaneNodeC, false);
	end;
end;

function TSW:draw()
	g_currentMission:addExtraPrintText(string.format("Dawka: %0.1f l/ha;   Num 5/8",self.literPerHa));
end;

function TSW:delete()
end;

function TSW:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TSW:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_8 then
		self.literPerHa = self.literPerHa + 1000;
	end;
	if isDown and sym == Input.KEY_KP_5 then
		self.literPerHa = self.literPerHa - 1000;
	end;
end;