--
--@ author		-	FIAT80-90DT
--@date			-	27.12.2011

SetFlapOpenEvent = {};
SetFlapOpenEvent_mt = Class(SetFlapOpenEvent, Event);

InitEventClass(SetFlapOpenEvent, "SetFlapOpenEvent");

function SetFlapOpenEvent:emptyNew()
    local self = Event:new(SetFlapOpenEvent_mt);
    self.className="SetFlapOpenEvent";
    return self;
end;

function SetFlapOpenEvent:new(vehicle, flapopen)
    local self = SetFlapOpenEvent:emptyNew()
    self.vehicle = vehicle;
	self.flapopen = flapopen;
    return self;
end;

function SetFlapOpenEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.flapopen = streamReadBool(streamId);
	self.vehicle:setFlapOpen(self.flapopen, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetFlapOpenEvent:new(self.vehicle, self.flapopen), nil, connection, self.vehicle);
    end;
end;

function SetFlapOpenEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.flapopen);
end;


function SetFlapOpenEvent.sendEvent(vehicle, flapopen, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFlapOpenEvent:new(vehicle, flapopen), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFlapOpenEvent:new(vehicle, flapopen));
		end;
	end;
end;

