--
--@ author		-	FIAT80-90DT
--@date			-	27.12.2011

SetDoorHighEvent = {};
SetDoorHighEvent_mt = Class(SetDoorHighEvent, Event);

InitEventClass(SetDoorHighEvent, "SetDoorHighEvent");

function SetDoorHighEvent:emptyNew()
    local self = Event:new(SetDoorHighEvent_mt);
    self.className="SetDoorHighEvent";
    return self;
end;

function SetDoorHighEvent:new(vehicle, doorhigh)
    local self = SetDoorHighEvent:emptyNew()
    self.vehicle = vehicle;
	self.doorhigh = doorhigh;
    return self;
end;

function SetDoorHighEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.doorhigh = streamReadInt8(streamId);
	self.vehicle:setDoorHigh(self.doorhigh, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorHighEvent:new(self.vehicle, self.doorhigh), nil, connection, self.vehicle);
    end;
end;

function SetDoorHighEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.doorhigh);
end;


function SetDoorHighEvent.sendEvent(vehicle, doorhigh, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorHighEvent:new(vehicle, doorhigh), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorHighEvent:new(vehicle, doorhigh));
		end;
	end;
end;

