--
-- InteractiveControlPanel
-- Specialization for InteractiveControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS2011
--

InteractiveControlPanel = {};

function InteractiveControlPanel.prerequisitesPresent(specializations)
	return true;
end;

function InteractiveControlPanel:load(xmlFile)

	source(Utils.getFilename("Scripts/InteractiveComponentInterface.lua", self.baseDirectory));
	
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#index"));

	self.attacherVehicleCopy = nil;
	
end;

function InteractiveControlPanel:delete()
end;

function InteractiveControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveControlPanel:update(dt)	
end;

function InteractiveControlPanel:draw()
end;

function InteractiveControlPanel:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	end;	
end;

function InteractiveControlPanel:onDetach()
	if self.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = self.attacherVehicleCopy:removeControlPanel(self);
	end;

	self.attacherVehicleCopy = nil;
end