-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses chunks that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- @author sandgroper...

herbiTankPlaceable = {};
herbiTankPlaceable_mt = Class(herbiTankPlaceable, Placeable);

InitObjectClass(herbiTankPlaceable, "herbiTankPlaceable");

function herbiTankPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, herbiTankPlaceable_mt);
    registerObjectClassName(self, "herbiTankPlaceable");
    return self;
end;

function herbiTankPlaceable:delete()
	delete(self);
    unregisterObjectClassName(self);
    herbiTankPlaceable:superClass().delete(self);
end;

function herbiTankPlaceable:deleteFinal()
    herbiTankPlaceable:superClass().deleteFinal(self);
end;

function herbiTankPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not herbiTankPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fillTriggers.fillTrigger1#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    

	self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fillTriggers.fillTrigger2#index"));
    SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);


	self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.fillTriggers.fillTrigger3#index"));
    SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
	
	delete(xmlFile);
    
	return true;
	
end;

function herbiTankPlaceable:update(dt)
end;
registerPlaceableType("herbiTankPlaceable", herbiTankPlaceable);