--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

-- Basis fr Placeable by Alex2009 & Sven777b, Spezifikation "SpeedCamera" by rafftnix. (February 2013) Erlaubnis dafr von Sven777b erhalten.

PlaceableSpeedCamera = {};
PlaceableSpeedCamera_mt = Class(PlaceableSpeedCamera, Placeable);
InitObjectClass(PlaceableSpeedCamera, "PlaceableSpeedCamera");

function PlaceableSpeedCamera:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, PlaceableSpeedCamera_mt);
    registerObjectClassName(self, "PlaceableSpeedCamera");
    return self;
end;

function PlaceableSpeedCamera:delete()
    removeTrigger(self.triggerNodeId);
    unregisterObjectClassName(self);
    PlaceableSpeedCamera:superClass().delete(self);
end;

function PlaceableSpeedCamera:deleteFinal()
    PlaceableSpeedCamera:superClass().deleteFinal(self);
end;

function PlaceableSpeedCamera:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not PlaceableSpeedCamera:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	if not moveMode then
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
		self:loadSpeedCamera(id, xmlFile);
		delete(xmlFile);
	end;
    return true;
end;

function PlaceableSpeedCamera:loadSpeedCamera(id, xmlFile)
	self.triggerNodeId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.SpeedCamera#triggerIndex"));
	
	local arrow = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.SpeedCamera#arrowIndex"));
	setVisibility(arrow, false);
	
	self.maxAllowedkmh = Utils.getNoNil(getUserAttribute(self.triggerNodeId, "maxAllowedkmh"), 50);
	self.pricePerKmh = Utils.getNoNil(getUserAttribute(self.triggerNodeId, "prizePerkmhToFast"), 20);
	self.triggerId = self.triggerNodeId;
	addTrigger(self.triggerId, "triggerCallback", self);
	self.lastPrice = 0;
	self.myTimer = 0;
	self.myTimerBackup = 5000;
	self.toFast = 0;
	self.lastDist = 0;
	self.vehicles = {}
	self.posX, self.posY, self.posZ = getWorldTranslation(getParent(self.triggerId));
	self.lastSpeedCameraCaughtDriver = nil;
end;


function PlaceableSpeedCamera:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter and g_server ~= nil then
		local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
		if vehicle ~= nil then
			if vehicle:getIsActive() and vehicle.motor ~= nil then
				table.insert(self.vehicles, vehicle);
			end;
		end;
	end;
end;

function PlaceableSpeedCamera:update(dt)
	if self.myTimer > 0 then
		if self.lastSpeedCameraCaughtDriver == nil then
			local text = string.gsub(g_i18n:getText("youWereToFast"), "toFast", tostring(self.toFast));
			text = string.gsub(text, "monetary", tostring(math.floor(self.lastPrice)));
			g_currentMission:addExtraPrintText(text);
		else
			local text = g_i18n:getText("someoneElseWasToFast");
			text = string.gsub(text, "user", tostring(self.lastSpeedCameraCaughtDriver));
			text = string.gsub(text, "toFast", tostring(self.toFast));
			text = string.gsub(text, "monetary", tostring(math.floor(self.lastPrice)));
			g_currentMission:addExtraPrintText(text);
		end;
		self.myTimer = self.myTimer - dt; 
	end;
end;

function PlaceableSpeedCamera:updateTick(dt)
	if g_server ~= nil then
		if self.vehicles[1] ~= nil then
			local x, y, z = getWorldTranslation(self.vehicles[1].rootNode);
			local dist = Utils.vector3Length(self.posX-x, self.posY-y, self.posZ-z);
			if self.lastDist == 0 then
				self.lastDist = dist;
			else
				if dist < self.lastDist then
					self:calculateMonetary(self.vehicles[1]);
				end;
				self.lastDist = 0;
				table.remove(self.vehicles, 1);
			end;
		end;
	end;
end;

function PlaceableSpeedCamera:calculateMonetary(vehicle)
	local kmh = math.min(100, math.max(0, vehicle.lastSpeed*vehicle.speedDisplayScale*3600));
	if kmh > self.maxAllowedkmh then
		local toFast = kmh - self.maxAllowedkmh;
		toFast = math.floor(toFast);
		local price = toFast * self.pricePerKmh;
		g_currentMission:addSharedMoney(-price);
		self:setWarning(vehicle, toFast, price);
	end;
end;

function PlaceableSpeedCamera:setWarning(vehicle, toFast, price)
	self.lastPrice = price;
	self.toFast = toFast
	self.myTimer = self.myTimerBackup;
	if vehicle:getIsActiveForInput(false) then
		self.lastSpeedCameraCaughtDriver = nil;
	else
		self.lastSpeedCameraCaughtDriver = vehicle.controllerName;
	end;
	if g_server ~= nil then
		SpeedCameraEvent.sendEvent(self, vehicle, toFast, price);
	end;
end;

registerPlaceableType("placeableSpeedCamera", PlaceableSpeedCamera);