-- by "Marhu" 
-- v 1.0
-- Date: 19.04.2013
--"Sort PDA Price and ad missing storage"

local ShortName={["Totale Mischration"] = "Mischration"}
local FillTypeIsFutter = {
				["grass"] = 7;
				["grass_windrow"] = 12;
				["forage"] = 21;
				["water"] = 16;
				["wheat_windrow"] = 10;
				["dryGrass_windrow"] = 13;
				["silage"] = 20;
				["milk"] = 14;
				["forage_mixing"] = 22;
				["chaff"] = 9;
				["dryGrass"] = 8;
			};

PDAfix = {};

function PDAfix:loadMap(name)
	
	
	self.MaxFTPP = 9 -- Max FillType per Page
	self.MaxSPP = 2 -- Max Station per Page
	self.MaxSilosPP = 10 -- Max Silos per Page
	self.StationOffset = 0
	self.FillTypeOffset = 0
	self.NumFillTypes = 0
	self.NumSilos = 0
	self.FillTypes = {}
	self.Station = {}
	self.Silo = {}
	
	local Station = {}
	local Feldfrucht = {}
	local Futter = {}
	local Sonstige = {}
	local findFillTypes = {}
	local findSilo = {}
	
    for k,tip in pairs(g_currentMission.tipTriggers) do
		
		if (tip.appearsOnPDA) then
			local name = tip.stationName
			if (g_i18n:hasText(tip.stationName)) then name = g_i18n:getText(tip.stationName); end;
			if not Station[name] then
				Station[name] = {}
				Station[name].tip = tip
			end
		end
		
		for i in pairs(tip.acceptedFillTypes) do
			--if i == Fillable.FILLTYPE_DRYGRASS_WINDROW then i = Fillable.FILLTYPE_GRASS_WINDROW end
			--if i == Fillable.FILLTYPE_DRYGRASS then i = Fillable.FILLTYPE_GRASS end
			if i == Fillable.FILLTYPE_BARLEY_WINDROW then i = Fillable.FILLTYPE_WHEAT_WINDROW end
			if (tip.appearsOnPDA) then
				if not findFillTypes[i] then
					findFillTypes[i] = true
					self.NumFillTypes = self.NumFillTypes + 1
					if FillTypeIsFutter[Fillable.fillTypeIntToName[i]] then
						Futter[i] = (Futter[i] or 0) + 1
					elseif FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[i]] then
						Feldfrucht[i] = (Feldfrucht[i] or 0) + 1
					else
						Sonstige[i] = (Sonstige[i] or 0) + 1
					end
				end
				
			end
			if tip.isFarmTrigger and tip.animalHusbandry == nil then
				if not findSilo[i] then
					findSilo[i] = true
					self.NumSilos = self.NumSilos + 1
					if FillTypeIsFutter[Fillable.fillTypeIntToName[i]] then
						Futter[i] = (Futter[i] or 0) + 2
					elseif FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[i]] then
						Feldfrucht[i] = (Feldfrucht[i] or 0) + 2
					else
						Sonstige[i] = (Sonstige[i] or 0) + 2
					end
				end
			end
		end
		
	end
	
	for k,v in pairs(Feldfrucht) do
		if v == 1 or v == 3 then
			table.insert(self.FillTypes,k)
		end
		if v == 2 or v == 3 then
			table.insert(self.Silo,k)
		end
	end
	for k,v in pairs(Futter) do
		if v == 1 or v == 3 then
			table.insert(self.FillTypes,k)
		end
		if v == 2 or v == 3 then
			table.insert(self.Silo,k)
		end
	end
	for k,v in pairs(Sonstige) do
		if v == 1 or v == 3 then
			table.insert(self.FillTypes,k)
		end
		if v == 2 or v == 3 then
			table.insert(self.Silo,k)
		end
	end
		
	for SName, v in pairs(Station) do
		local t = {}
		t.stationName = SName;
		t.stationRawName = SName;
		t.tipTrigger = v.tip
		table.insert(self.Station,t)
	end
	
	self.Seite = 1
	self.NumSeiten = (math.ceil(table.getn(self.Station) / self.MaxSPP)  *  math.ceil(self.NumFillTypes / self.MaxFTPP)) + 1
		
end;

function PDAfix:deleteMap()
	self.hookPDA = nil;
	self.FillTypes = {};
	self.Silo = {};
end;

function PDAfix:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PDAfix:keyEvent(unicode, sym, modifier, isDown)
end;

function PDAfix:update(dt)
		
	if not self.hookPDA then
		self.hookPDA = true;
		if MissionPDA.draw ~= nil then
			local orgdraw = MissionPDA.draw;
			MissionPDA.draw = function(a, b, c, d)
				
				if (a.screen ~= 4) or self.Stop then
					orgdraw(a, b, c, d);
				else
					-- PDA Hintergrund
					a.hudPDABackgroundOverlay:render();
					
					local y = a.pdaHeadRow
						
					if self.GreatDemandSeite then

						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(true);
						renderText(a.pdaPricesCol[1],y,a.pdaFontSize,g_i18n:getText("PDATitleGreatDemands"));
						y = y - (a.pdaRowSpacing * 2);
						setTextBold(false);
						local greatDemands = g_currentMission.economyManager.greatDemands
						local find = false
						for i=1,table.getn(greatDemands) do
							if greatDemands[i].isRunning then
								find = true
								local name = greatDemands[i].stationName;
								if g_i18n:hasText(name) then name = g_i18n:getText(name); end;
								renderText(a.pdaPricesCol[1],y,a.pdaFontSize,name);
								local t = Fillable.fillTypeIndexToDesc[greatDemands[i].fillTypeIndex].nameI18N
								t = (ShortName[t] or t)..string.format(" x%.1f",greatDemands[i].demandMultiplier)
								renderText(a.pdaPricesCol[2],y,a.pdaFontSize,t);
								renderText(a.pdaPricesCol[3],y,a.pdaFontSize,
									string.format(g_i18n:getText("PDAGreatDemandTimeRemaining"),greatDemands[i].demandDuration));
								y = y - a.pdaRowSpacing;
							end
						end
						if not find then
							renderText(a.pdaPricesCol[1],y,a.pdaFontSize,g_i18n:getText("PDANoGreatDemands"));
						end
						
					else	
					
						table.sort(self.Station, MissionPDA.tipTriggerSorter)
						
						setTextAlignment(RenderText.ALIGN_CENTER);
						
						local priceMultipliers = {}
						setTextBold(true);
						local Col=2;
						local j = 1
						for i = 1 + self.StationOffset, self.MaxSPP+self.StationOffset do
							if self.Station[i] then
								priceMultipliers[j] = {}
								for index in pairs(self.Station[i].tipTrigger.acceptedFillTypes) do
									priceMultipliers[j][index] = self.Station[i].tipTrigger.priceMultipliers[index]
								end
								local x = a.pdaPricesCol[Col] + ((a.pdaPricesCol[Col+1] - a.pdaPricesCol[Col])/2) -  getTextWidth(a.pdaFontSize ,"00");
								renderText(x,y,a.pdaFontSize,self.Station[i].stationRawName); -- Stations Namen
								Col = Col + 1;
								j = j + 1
							end
						end
										
						y = y - a.pdaRowSpacing;
						setTextBold(false)
						local pricePerTon = g_i18n:getText("PricePerTon");
						
						setTextAlignment(RenderText.ALIGN_LEFT);
						
						local PriceArrow = 1
						
						for i = 1, table.getn(self.FillTypes) do
							if i > self.FillTypeOffset + self.MaxFTPP then 
								break;
							elseif i > self.FillTypeOffset then
								local Index = self.FillTypes[i]
						
								local name = Fillable.fillTypeIndexToDesc[Index].nameI18N
								if Fillable.FILLTYPE_PIG and Index == Fillable.FILLTYPE_PIG then
									name = (ShortName[name] or name);
								else
									name = (ShortName[name] or name).." "..pricePerTon;
								end
																
								local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
								local price = Fillable.fillTypeIndexToDesc[Index].pricePerLiter * difficultyMultiplier;
															
								setTextAlignment(RenderText.ALIGN_LEFT);
								renderText(a.pdaPricesCol[1],y,a.pdaFontSize,name); --FillType Name
								Col = 2;
								setTextAlignment(RenderText.ALIGN_RIGHT);
								
								for j = 1 ,table.getn(priceMultipliers) do
									if priceMultipliers[j][Index] then
										local x = a.pdaPricesCol[Col] + ((a.pdaPricesCol[Col+1] - a.pdaPricesCol[Col])/2)
										local price2 = price * priceMultipliers[j][Index]
										local greatDemands = g_currentMission.economyManager.greatDemands
										for k = 1, table.getn(greatDemands) do
											if greatDemands[k].isRunning then -- greatDemands
												if greatDemands[k].fillTypeIndex == Index and 
												   greatDemands[k].stationName == self.Station[j+self.StationOffset].tipTrigger.stationName then
													setTextColor(0.2, 1, 0.2, 1)
													price2 = price2 * greatDemands[k].demandMultiplier;
												end
											end
										end
										if Fillable.FILLTYPE_PIG and Index == Fillable.FILLTYPE_PIG then
											price2 = math.ceil(price2);
										else
											price2 = math.ceil(price2 * 1000);
										end
										renderText(x,y,a.pdaFontSize,string.format("%d", price2)); --Preis
										setTextColor(1, 1, 1, 1)
									end
									Col = Col + 1
								end
								
								-- Trend Pfeile
								if (Fillable.fillTypeIndexToDesc[Index].pricePerLiter < Fillable.fillTypeIndexToDesc[Index].previousHourPrice) then
									a.pdaPriceArrows[PriceArrow]:setImage(a.priceArrowDown)
								elseif (Fillable.fillTypeIndexToDesc[Index].pricePerLiter > Fillable.fillTypeIndexToDesc[Index].previousHourPrice) then
									a.pdaPriceArrows[PriceArrow]:setImage(a.priceArrowUp)
								else
									a.pdaPriceArrows[PriceArrow]:setImage(a.priceArrowFlat)
								end;
								a.pdaPriceArrows[PriceArrow].x = a.pdaPricesCol[4]
								
								a.pdaPriceArrows[PriceArrow]:render();
															
								PriceArrow = PriceArrow + 1
								
								y = y - a.pdaRowSpacing;
							end

						end
					end
					
					-- Seiten Zahl
					setTextAlignment(RenderText.ALIGN_RIGHT)
					renderText(a.pdaCoordsXPos + 0.004, a.pdaCoordsYPos - 0.002,a.pdaFontSize - 0.002,
						string.format("%d/%d", self.Seite, self.NumSeiten));
					setTextAlignment(RenderText.ALIGN_LEFT);
					
					-- Ramen
					a.hudPDAFrameOverlay:render();

					-- Titel
					setTextBold(true);
					setTextColor(0,0,0, 1);
					renderText(a.pdaTitleX - 0.001,a.pdaTitleY - 0.002,a.pdaTitleTextSize,a.textTitles[4]);
					setTextColor(1,1,1, 1);
					renderText(a.pdaTitleX,a.pdaTitleY,a.pdaTitleTextSize,a.textTitles[4]);
					
					-- Hilfe Text
					g_currentMission:addHelpButtonText(g_i18n:getText("PDAShowNextScreen"), InputBinding.TOGGLE_PDA);
					g_currentMission:addHelpButtonText(g_i18n:getText("PDAShowNextStations"), InputBinding.TOGGLE_PDA_ZOOM);
					
					--Seiten Blttern
					if InputBinding.hasEvent(InputBinding.TOGGLE_PDA_ZOOM) then
						if self.GreatDemandSeite then
							self.GreatDemandSeite = nil
							self.Seite = 1
						else
							self.StationOffset = self.StationOffset + self.MaxSPP;
							self.Seite = self.Seite + 1
							if self.StationOffset >= table.getn(self.Station) then
								self.StationOffset = 0
								self.FillTypeOffset = self.FillTypeOffset + self.MaxFTPP
								if self.FillTypeOffset >= self.NumFillTypes then
									self.FillTypeOffset = 0
									self.GreatDemandSeite = true
								end
							end
						end

						playSample(a.pdaBeepSound, 1, 0.5, 0);
					end;
				end 
			end;
		end;
		
		table.remove(g_currentMission.missionPDA.statsPages,1)
		local SiloPages = math.ceil((self.NumSilos+1) / self.MaxSilosPP)
		for i = 1 ,SiloPages do
			MissionPDA.addStatsPage(g_currentMission.missionPDA, self.DrawFarmSilos,self,"Silo"..i,i);
		end
		
		for i = 1, table.getn(g_currentMission.missionPDA.statsPages) do
			local page = g_currentMission.missionPDA.statsPages[i]
			if page.target and page.target.drawStatsPageAdditionalFarmSilos then
				table.remove(g_currentMission.missionPDA.statsPages,i)
				break;
			end
		end
	end;
		
end;

function PDAfix:updateTick(dt)
end;

function PDAfix:draw()
end;

function PDAfix:DrawFarmSilos(a)
	
	local von, bis, num = string.find(a,"(%d)")
	local off = ((tonumber(num)-1) * self.MaxSilosPP)
	local y = g_currentMission.missionPDA.pdaHeadRow - (g_currentMission.missionPDA.pdaRowSpacing/2)
	setTextColor(1, 1, 1, 1)
	local Gras,Stroh = nil,nil
	for i = 1, table.getn(self.Silo) do
		if i > off + self.MaxSilosPP then 
			break;
		elseif i > off then
			Index = self.Silo[i]
								
			local name = Fillable.fillTypeIndexToDesc[Index].name.."_storage"
			if g_i18n:hasText(name) then
				name = g_i18n:getText(name)
			elseif g_i18n:hasText("storage") then
				name = Fillable.fillTypeIndexToDesc[Index].nameI18N..g_i18n:getText("storage")
			else
				name = Fillable.fillTypeIndexToDesc[Index].nameI18N
			end
			name = name.." ["..g_i18n:getText("fluid_unit_short").."]"
															
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(g_currentMission.missionPDA.pdaPricesCol[1],y,g_currentMission.missionPDA.pdaFontSize,name); --FillType Name

			setTextAlignment(RenderText.ALIGN_RIGHT);
			
			local Amount = 0
			--if Index == Fillable.FILLTYPE_GRASS_WINDROW then
				--Amount = g_i18n:getFluid(g_currentMission:getSiloAmount(Index)+g_currentMission:getSiloAmount(Fillable.FILLTYPE_DRYGRASS_WINDROW))
			--elseif Index == Fillable.FILLTYPE_GRASS then
				--Amount = g_i18n:getFluid(g_currentMission:getSiloAmount(Index)+g_currentMission:getSiloAmount(Fillable.FILLTYPE_DRYGRASS))
			if Index == Fillable.FILLTYPE_WHEAT_WINDROW then
				Amount = g_i18n:getFluid(g_currentMission:getSiloAmount(Index)+g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW))
			else
				Amount = g_i18n:getFluid(g_currentMission:getSiloAmount(Index))
			end
						
			renderText(g_currentMission.missionPDA.pdaPricesCol[3],y,g_currentMission.missionPDA.pdaFontSize,string.format("%d", Amount)); --Amount
			
			y = y - g_currentMission.missionPDA.pdaRowSpacing;
		end
	end
	if tonumber(num) == math.ceil((self.NumSilos+1) / self.MaxSilosPP) then
		setTextAlignment(RenderText.ALIGN_LEFT);
		renderText(g_currentMission.missionPDA.pdaPricesCol[1],y,g_currentMission.missionPDA.pdaFontSize,g_i18n:getText("Eggs_carrying")); --FillType Name
		setTextAlignment(RenderText.ALIGN_RIGHT);
		local Amount = g_currentMission:getSiloAmount(Fillable.fillTypeNameToInt["egg"])
		renderText(g_currentMission.missionPDA.pdaPricesCol[3],y,g_currentMission.missionPDA.pdaFontSize,string.format("%d", Amount)); --Amount
	end
	
end;


addModEventListener(PDAfix);