--
-- SampleModMap
--
-- @author  Luxfarm
-- @date  06/04/13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.setup_map_new ~= nil then
        --fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays")  -- If map provides its own fill-type HUD overlay icons.
        fmcSoilMod.setup_map_new() -- If using icons included with the SoilManagement.ZIP mod.
    end
    --## SoilMod - End ############################################################
    --#############################################################################

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.teardown_map_delete ~= nil then
        fmcSoilMod.teardown_map_delete()
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/BPV2.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Scripts/SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("Scripts/pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("Scripts/pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -133.05, -580.27, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -281.6, -576.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 292, -740.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 557.6, -648.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 148, -763, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 287.7, -652.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 224.2, -723.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.postInit_loadMapFinished ~= nil then
        if fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected ~= nil then
            -- If needed, set up this map's custom fruit-types fertilizer-boost and herbicide-affected attributes.
            
            -- <<Examples>>
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("tomato"   ,"fertilizer"   ,"herbicide3")
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("soybean"  ,"fertilizer2"  ,"herbicide" )
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("pumpkin"  ,"fertilizer3"  ,"herbicide2")
        end
        --
        if fmcSoilMod.setMapProperty ~= nil then
            -- Some of SoilMod's map-properties can be overwritten by the map-mod itself.
        
            -- <<Examples>>
            fmcSoilMod.setMapProperty("reduceWindrows",          false) -- (boolean) If windrows/swath should be reduced by 1 height-level during growth-cycle
            fmcSoilMod.setMapProperty("removeSprayMoisture",     true)  -- (boolean) If spray-moisture should be removed (vaporised) during growth-cycle
            fmcSoilMod.setMapProperty("disableWithering",        true)  -- (boolean) If crop withering should be disabled
            fmcSoilMod.setMapProperty("delayGrowthCycle#days",   0)     -- (integer) How many in-game days to skip before activating growth-cycle again
            fmcSoilMod.setMapProperty("startGrowthCycle#hour",   6)     -- (integer) At what hour of the in-game day should the growth-cycle start
	    fmcSoilMod.setMapProperty("updateDelayMs",   10)     -- (integer) Milliseconds, delay between update-of-squares during growth-cycle. Lower values=quicker but cause more lag in multiplayer (default=62)
	    fmcSoilMod.setMapProperty("fertilizerSynthetic#firstGrowthState",   0)     -- (integer) When fertilizer can be applied during first growth state 
	    fmcSoilMod.setMapProperty("fertilizerSynthetic#lastGrowthState",   4)     -- (integer) When fertilizer can be applied during first growth state
        end
        --
        fmcSoilMod.postInit_loadMapFinished()
    end
    --## SoilMod - End ############################################################
    --#############################################################################


    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.update ~= nil then
        fmcSoilMod.update(dt)
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.draw ~= nil then
        fmcSoilMod.draw()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;