SetReleasePickUp = {};
SetReleasePickUp_mt = Class(SetReleasePickUp, Event);

InitEventClass(SetReleasePickUp, "SetReleasePickUp");

function SetReleasePickUp:emptyNew()
    local self = Event:new(SetReleasePickUp_mt);
    self.className="SetReleasePickUp";
    return self;
end;

function SetReleasePickUp:new(vehicle, state)
    local self = SetReleasePickUp:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetReleasePickUp:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetReleasePickUp:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetReleasePickUp:run(connection)
	self.vehicle:releasePickUp(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetReleasePickUp:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetReleasePickUp.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetReleasePickUp:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetReleasePickUp:new(vehicle, state));
		end;
	end;
end;