SetOpenSlideEvent = {};
SetOpenSlideEvent_mt = Class(SetOpenSlideEvent, Event);

InitEventClass(SetOpenSlideEvent, "SetOpenSlideEvent");

function SetOpenSlideEvent:emptyNew()
    local self = Event:new(SetOpenSlideEvent_mt);
    self.className="SetOpenSlideEvent";
    return self;
end;

function SetOpenSlideEvent:new(vehicle, state)
    local self = SetOpenSlideEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetOpenSlideEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetOpenSlideEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetOpenSlideEvent:run(connection)
	self.vehicle:openSlide(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetOpenSlideEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetOpenSlideEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetOpenSlideEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetOpenSlideEvent:new(vehicle, state));
		end;
	end;
end;