﻿--
-- Heath SuperChaser
--
-- author Mythos
-- date  20/06/2011
-- www.Virtual-Farmers.gr
-- Copyright (C) ARM Team, All Rights Reserved.

-- changes for Proag 16K: KillaBot & Wodka-Bull24
-- with permission from Mythos
-- www.HoT-Base.de


Heath = {};
--________________________________________________________________________________________________________________________________________________________
function Heath.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:load(xmlFile)

	-- Functions
	self.FiHeBa= SpecializationUtil.callSpecializationsFunction("FiHeBa");
	
	self.FiDi= SpecializationUtil.callSpecializationsFunction("FiDi");
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");	
	
	-- Animations
	self.workmodeEven = getXMLString(xmlFile, "vehicle.workmodeEven#animationName");
	self.workmodeOdd = getXMLString(xmlFile, "vehicle.workmodeOdd#animationName");
	self.workmodeZero = getXMLString(xmlFile, "vehicle.workmodeZero#animationName");
	self.transportmodeEven = getXMLString(xmlFile, "vehicle.transportmodeEven#animationName");
	self.transportmodeOdd = getXMLString(xmlFile, "vehicle.transportmodeOdd#animationName");
	self.transportmodeFull = getXMLString(xmlFile, "vehicle.transportmodeFull#animationName");
	
	self.transportUnloaded = getXMLString(xmlFile, "vehicle.transportUnloaded#animationName");
	self.transportUnloadedFull = getXMLString(xmlFile, "vehicle.transportUnloadedFull#animationName");
	self.transportUnloadedEven = getXMLString(xmlFile, "vehicle.transportUnloadedEven#animationName");
	self.transportSlider = getXMLString(xmlFile, "vehicle.transportSlider#animationName");
	self.transportUnloadedA = getXMLString(xmlFile, "vehicle.transportUnloadedA#animationName");
	self.transportUnloadedFullA = getXMLString(xmlFile, "vehicle.transportUnloadedFullA#animationName");
	self.transportUnloadedEvenA = getXMLString(xmlFile, "vehicle.transportUnloadedEvenA#animationName");
	
	self.preparefromOdd = getXMLString(xmlFile, "vehicle.preparefromOdd#animationName");
	self.preparefromEven = getXMLString(xmlFile, "vehicle.preparefromEven#animationName");
	self.preparefromFull = getXMLString(xmlFile, "vehicle.preparefromFull#animationName");
	
	self.loadEven2 = getXMLString(xmlFile, "vehicle.loadEven2#animationName");
	self.loadEven4 = getXMLString(xmlFile, "vehicle.loadEven4#animationName");
	self.loadEven6 = getXMLString(xmlFile, "vehicle.loadEven6#animationName");
	self.loadEven8 = getXMLString(xmlFile, "vehicle.loadEven8#animationName");
	self.loadOdd = getXMLString(xmlFile, "vehicle.loadOdd#animationName");
	self.loadFull = getXMLString(xmlFile, "vehicle.loadFull#animationName");
	
	self.unload = getXMLString(xmlFile, "vehicle.unload#animationName");
	
	self.step1 = getXMLString(xmlFile, "vehicle.step1#animationName");
	self.step2 = getXMLString(xmlFile, "vehicle.step2#animationName");
	self.step3 = getXMLString(xmlFile, "vehicle.step3#animationName");
	self.step4 = getXMLString(xmlFile, "vehicle.step4#animationName");
	
	self.slide1 = getXMLString(xmlFile, "vehicle.slide1#animationName");
	self.slide2 = getXMLString(xmlFile, "vehicle.slide2#animationName");
	self.slide3 = getXMLString(xmlFile, "vehicle.slide3#animationName");
	self.slide3a = getXMLString(xmlFile, "vehicle.slide3a#animationName");
	self.slide4 = getXMLString(xmlFile, "vehicle.slide4#animationName");

	-- Indexs
	self.base = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.base#index"));
	self.slider = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.slider#index"));
	self.balesJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#index"));
	self.ref = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.baleRef#index"));
	
	self.spikeJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spikes#joint"));
	self.haySpike = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spikes#hay"));
	self.strawSpike = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spikes#straw"));
	self.haySpikeEven = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spikes#hayEven"));
	self.strawSpikeEven = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spikes#strawEven"));
	
	self.linkOddBale = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.loadedBales.bale1#index"));
	self.linkEvenBale = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.loadedBales.bale2#index"));
	
	self.hayBaleFilename = getXMLString(xmlFile, "vehicle.bales.bale1#filename");
	self.strawBaleFilename = getXMLString(xmlFile, "vehicle.bales.bale2#filename");
	
	self.tim = 1000;
	-- Particles
	self.sParticles = {};
	local i = 0;
    while true do
        local key = string.format("vehicle.sParticles.pSystem(%d)", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.. "#index"));
		if node == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sParticles, key, node, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	self.hParticles = {};
	local i = 0;
    while true do
        local key = string.format("vehicle.hParticles.pSystem(%d)", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.. "#index"));
		if node == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.hParticles, key, node, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	-- Bale Types
	self.baleTypes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTypes.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local filename = getXMLString(xmlFile, key.."#type");
		if filename ~= nil then
			table.insert(self.baleTypes, filename);
		end;
		i = i + 1;
	end;

	-- Bales Loaded Tables
	self.hayBales = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.hayBales.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			table.insert(self.hayBales, index);
		end;
		i = i + 1;
	end;
		
	self.strawBales = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.strawBales.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			table.insert(self.strawBales, index);
		end;
		i = i + 1;
	end;
	self.numMaxBales = i;
	
	-- Booleans
	self.i = {};
	self.workMode = false;
	self.prepareMode = false;
	self.unloadMode = false;
	self.unloaded = false;
	
	self.counter = 0;
	self.animEnded = true;
	self.foundIt = false;
	self.baleId = nil;
	self.fruitBale = nil;
	
	self.old_dif = 0;
	
	self.okai = false;
	self.okai2 = false;
	self.okai3 = false;
	
	self.itsOver = false;
	self.itsOver2 = false;
	self.itsOver3 = false;
	self.endGame = false;
	self.ready2go = false;
	self.abort = false;
	self.tranprep = false;
	
	self.usedFruitType = 0;
	self.bales = {};
	
	self.setTim = false;
	
	self.fillLevel = 0;
    self.fillLevelMax = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.capacity"), 0);

end;

--________________________________________________________________________________________________________________________________________________________
function Heath:delete()
	Utils.deleteParticleSystem(self.hParticles);
	Utils.deleteParticleSystem(self.sParticles);
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:mouseEvent(posX, posY, isDown, isUp, button)

end;

--________________________________________________________________________________________________________________________________________________________
function Heath:keyEvent(unicode, sym, modifier, isDown)

end;

--________________________________________________________________________________________________________________________________________________________
function Heath:update(dt)

if self:getIsActiveForInput() and self:getIsActive() then
	if self.animEnded then
		if self.unloadMode then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self:MPCode(23);
			end;
		elseif self.unloaded then
			if not self.endGame then
				
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
						self.abort = true;
						self:MPCode(20, not self.unloaded);
					end;
					
					
					
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
						self.setTim = true;
						self:MPCode(24);
					end;
				
			elseif self.ready2go then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:MPCode(20, not self.unloaded);
				end;
			end;
		else
			if self.abort and (self.counter == 8 or self.counter <= 5) then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					self:MPCode(22);
				end;
			elseif self.abort and self.counter ~= 8 and self.counter ~= 5 then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:MPCode(20, not self.workMode);
				end;
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					self:MPCode(22);
				end;
			else
				if not self.workMode and self.counter == 8 then
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
						self:MPCode(22);
					end;
				else
					if not self.workMode then
						if self.counter == 0 then
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								self:MPCode(20, not self.workMode);
							end;
						else
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								self:MPCode(20, not self.workMode);
							end;
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
								self:MPCode(22);
							end;
						end;
					else
						if self.counter == 8 then
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								self:MPCode(20, not self.workMode);
							end;
						else
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								self:MPCode(20, not self.workMode);
							end;
							if self.foundIt then
								if math.mod(self.counter, 2) == 0 then
									if self.fruitBale:lower():find("hay") ~= nil then
										self.fruitBale = "hay";
										self.state = 1;
										self.filename = self.hayBaleFilename;
									else
										self.fruitBale = "straw";
										self.state = 2;
										self.filename = self.strawBaleFilename;
									end;
								else
									if self.fruitBale:lower():find("hay") ~= nil then
										self.fruitBale = "hay";
										self.state = 3;
										self.filename = self.hayBaleFilename;
									else
										self.fruitBale = "straw";
										self.state = 4;
										self.filename = self.strawBaleFilename;
									end;
								end;
								--print(self.fruitBale .. " / " .. self.state)
								self:MPCode(21, nil, self.state);
							else
								self:FiHeBa(self.spikeJoint);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

end;

--________________________________________________________________________________________________________________________________________________________
function Heath:draw()

if self.animEnded then
	if self.unloadMode then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PREPAREMODE2"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	elseif self.unloaded then
		if not self.endGame then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ABORT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		elseif self.ready2go then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORTMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
	else
		if self.abort then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PREPAREMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);	
		else
			if self.counter == 8 and not self.workMode then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PREPAREMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			else
				if not self.workMode then
					if self.counter == 0 then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WORKMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WORKMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PREPAREMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
					end;
				else
					if	self.counter == 8 then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORTMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORTMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
					end;
				end;
			end;
		end;
	end;
end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:MPCode(mode, bool, state, dif, olddif, noEventSend)
	MPEvent.sendEvent(self, mode, bool, state, dif, olddif, noEventSend);
	
--______________________________________________________________________________
if mode == 20 then
--______________________________________________________________________________
	if bool then
		if math.mod(self.counter, 2) == 0 then
			if self.counter == 0 then
				self:playAnimation(self.workmodeZero, 1, nil, true);
				self.workMode = true;
				self.abort = false;
			else
				self:playAnimation(self.workmodeOdd, 1, nil, true);
				self.workMode = true;
				self.abort = false;
			end;
		else
			self:playAnimation(self.workmodeEven, 1, nil, true);
			self.workMode = true;
			self.abort = false;
		end;
	else
		
		if self.unloaded then
			
			if self.counter == 8 then
				self:playAnimation(self.transportUnloadedFullA, 1, nil, true);
				self.unloaded = false;
				self.ready2go = false;
				self.endGame = false;
				self.okai = false;
			elseif self.counter == 6 then
				self:playAnimation(self.transportUnloadedEvenA, 1, nil, true);
				self.unloaded = false;
				self.ready2go = false;
				self.endGame = false;
				self.okai = false;
			elseif self.counter == 0 then
				self:playAnimation(self.transportUnloaded, 1, nil, true);
				self.unloaded = false;
				self.ready2go = false;
				self.endGame = false;
				self.okai = false;
			else
				
				self:playAnimation(self.transportUnloadedA, 1, nil, true);
				self.unloaded = false;
				self.ready2go = false;
				self.endGame = false;
				self.okai = false;
				self.tranprep = true;
			end;		
			
		elseif math.mod(self.counter, 2) == 0 then
			if self.counter == 0 then
				self:playAnimation(self.workmodeZero, -1, nil, true);
				self.workMode = false;
				self.foundIt = false;
			elseif self.counter == 8 then
				self:playAnimation(self.transportmodeFull, 1, nil, true);
				self.workMode = false;
				self.foundIt = false;
			else
				self:playAnimation(self.transportmodeEven, 1, nil, true);
				self.workMode = false;
				self.foundIt = false;
			end;
		else
			self:playAnimation(self.transportmodeOdd, 1, nil, true);
			self.workMode = false;
			self.foundIt = false;
		end;
	end;
--______________________________________________________________________________
elseif mode == 21 then	
--______________________________________________________________________________
	if self.counter == 7 then
		local object = g_currentMission:getNodeObject(self.baleId);
		if object ~= nil then
			object:delete();
		end;
		
		
		if state==3 then
			setVisibility(self.haySpikeEven, true);
		elseif state==4 then
			setVisibility(self.strawSpikeEven, true);
		end;
		
		
		self:playAnimation(self.loadFull, 1, nil, true);
		self.counter = self.counter + 1;
		self.fillLevel = self.counter;
		self.foundIt = false;
	elseif math.mod(self.counter, 2) == 0 then
		local object = g_currentMission:getNodeObject(self.baleId);
		if object ~= nil then
			object:delete();
		end;
		
		
		if state==1 then
			setVisibility(self.haySpike, true);
		elseif state==2 then
			setVisibility(self.strawSpike, true);
		end;
		
		self:playAnimation(self.loadOdd, 1, nil, true);
		self.counter = self.counter + 1;
		self.fillLevel = self.counter;
		self.foundIt = false;
	else
		local object = g_currentMission:getNodeObject(self.baleId);
		if object ~= nil then
			object:delete();
		end;
		
		if state==3 then
			setVisibility(self.haySpikeEven, true);
		elseif state==4 then
			setVisibility(self.strawSpikeEven, true);
		end;
		
		
		if self.counter ==1 then
			self:playAnimation(self.loadEven2, 1, nil, true);
		elseif self.counter ==3 then
			self:playAnimation(self.loadEven4, 1, nil, true);
		elseif self.counter ==5 then
			self:playAnimation(self.loadEven6, 1, nil, true);
		elseif self.counter ==7 then
			self:playAnimation(self.loadEven8, 1, nil, true);
		end;
		self.counter = self.counter + 1;
		self.fillLevel = self.counter;
		self.foundIt = false;
	end;
--______________________________________________________________________________
elseif mode == 22 then
--______________________________________________________________________________
	if self.counter == 8 then
		self:playAnimation(self.preparefromFull, 1, nil, true);
		self.unloadMode = true;
		self.abort = false;
		self.state = 5;
	elseif math.mod(self.counter, 2) == 0 then
		self:playAnimation(self.preparefromEven, 1, nil, true);
		self.unloadMode = true;
		self.abort = false;
		self.state = 5;
	else
		self:playAnimation(self.preparefromOdd, 1, nil, true);
		if self.savestate == 1 then
			setVisibility(self.hayBales[self.counter], true);
		else
			setVisibility(self.strawBales[self.counter], true);
		end
		setVisibility(self.haySpikeEven, false);
		setVisibility(self.haySpike, false);
		setVisibility(self.strawSpike, false)
		setVisibility(self.strawSpikeEven, false);
		
		self.unloadMode = true;
		self.abort = false;
		self.state = 5;
	end;
--______________________________________________________________________________
elseif mode == 23 then
--______________________________________________________________________________
	self:playAnimation(self.unload, 1, nil, true);
	self.unloadMode = false;
	self.unloaded = true;
	self.foundIt = false;
--______________________________________________________________________________
elseif mode == 24 then
--______________________________________________________________________________
	for i,v in pairs(self.hayBales) do
		if getVisibility(v) then
			if self.isServer then
				self.filename = self.hayBaleFilename;
				local baleObject = Bale:new(self.isServer, self.isClient);
				local objectFilename = Utils.getFilename(self.filename, self.baseDirectory);
				local x,y,z = getWorldTranslation(v);
				local rx,ry,rz = getWorldRotation(v);
				baleObject:load(objectFilename, x,y,z,rx,ry,rz);
				baleObject:register();
			end;
		end;
	end;
	
	for i,v in pairs(self.strawBales) do
		if getVisibility(v) then
			if self.isServer then
				self.filename = self.strawBaleFilename;
				local baleObject = Bale:new(self.isServer, self.isClient);
				local objectFilename = Utils.getFilename(self.filename, self.baseDirectory);
				local x,y,z = getWorldTranslation(v);
				local rx,ry,rz = getWorldRotation(v);
				baleObject:load(objectFilename, x,y,z,rx,ry,rz);
				baleObject:register();
			end;
		end;
	end;

	for i,v in pairs(self.hayBales) do
		setVisibility(v, false);
	end;
	
	for i,v in pairs(self.strawBales) do
		setVisibility(v, false);
	end;
	
	self.counter = 0;
	
	local limit = 1;
	for index, item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then
			local refx, refy, refz = getWorldTranslation(self.ref);
			local bx, by, bz = getWorldTranslation(item.item.nodeId);
			self.distance = Utils.vector3Length(refx-bx, refy-by, refz-bz);
			if self.distance < limit then
				self.baleId2 = item.item.nodeId;
				break;
			end;
		else
			self.baleId2 = nil;
		end;
	end;
	
	setTranslation(self.balesJoint, 0, 0, 6.661);
	self.fillLevel = 0;
	
	self.endGame = true;
	if self.tranprep then
		self.tranprep = false;
	end;
	Utils.setEmittingState(self.unParticles, true);
--______________________________________________________________________________
elseif mode == 25 then
--______________________________________________________________________________
	if state==1 then
		local i = self.counter;
		self.savestate = state;
	elseif state==2 then
		local i = self.counter;
		self.savestate = state;
	elseif state==3 then
		setVisibility(self.haySpikeEven, false);
		local i = self.counter;
		setVisibility(self.hayBales[i], true);
		setVisibility(self.haySpike, false);
		setVisibility(self.strawSpike, false)
		if self.savestate == 1 then
			setVisibility(self.hayBales[i-1], true);
		else
			setVisibility(self.strawBales[i-1], true);
		end
	elseif state==4 then
		setVisibility(self.strawSpikeEven, false);
		local i = self.counter;
		setVisibility(self.strawBales[i], true);
		setVisibility(self.haySpike, false);
		setVisibility(self.strawSpike, false)
		if self.savestate == 1 then
			setVisibility(self.hayBales[i-1], true);
		else
			setVisibility(self.strawBales[i-1], true);
		end
	end;
	self.itsOver = true;
--______________________________________________________________________________
elseif mode == 26 then
--______________________________________________________________________________

--______________________________________________________________________________
elseif state==5 then
	if self.counter ==1 then
		self:playAnimation(self.slide1, 1, nil, true);
	elseif self.counter ==2 or self.counter ==3 then
		self:playAnimation(self.slide2, 1, nil, true);
	elseif self.counter ==4 or self.counter ==5 then
		self:playAnimation(self.slide3, 1, nil, true);
	elseif self.counter ==6 or self.counter ==7 then
		self:playAnimation(self.slide4, 1, nil, true);
	end;
elseif state==6 then
	self.setTim = false;
	Utils.setEmittingState(self.unParticles, false);
	self.tim = 1000;
elseif state==7 then
	self:playAnimation(self.transportSlider, 1, nil, true);
	self.old_dif = 0;
	self.ready2go = true;
elseif state==8 then
	translate(self.slider, 0, 0, -(dif-olddif));
	self.old_dif = dif;
end;
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:updateTick(dt)
if self:getIsActive() then

	if self.endGame and not self.okai and self.baleId2 ~= nil then
			self.okai = true;
	elseif self.endGame and not self.okai and self.baleId2 == nil then
		self.okai = true;
	end;
	
	self.old_dif = 0;
	self.ready2go = true;
	
	for name,v in pairs(self.animations) do
		if self.activeAnimations[name] ~= nil then
			self.animEnded = false;
			self.animName = name;
			break;
		else
			self.animEnded = true;
			self.animName = nil;
			self.itsOver = false;
			self.itsOver2 = false;
			self.itsOver3 = false;
		end;
	end;
	
	if self.setTim then
		self.tim = self.tim - dt;
		if self.tim <0 then
			self.state = 6;
			self:MPCode(nil, nil, self.state);
		end;
	end;
	
	if self.animName ~= nil and self.animName == "WorkModeOdd" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 2500 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "WorkModeOdd" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 3100 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "WorkModeEven" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 2500 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "WorkModeEven" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 3100 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;

	if not self.tranprep then
		if self.animName ~= nil and self.animName == "PrepareModeEven" and not self.okai2 then
			self.animTime = self:getRealAnimationTime(self.animName);
			if self.animTime > 0 then
				Utils.setEmittingState(self.sParticles, true);
				self.okai2 = true;
			end;
		end;
		
		if self.animName ~= nil and self.animName == "PrepareModeEven" and self.okai2 then
			self.animTime = self:getRealAnimationTime(self.animName);
			if self.animTime > 600 then
				Utils.setEmittingState(self.sParticles, false);
				self.okai2 = false;
			end;
		end;
	end;
	
	if self.tranprep == false or (self.tranprep and self.counter == 7) then
		if self.animName ~= nil and self.animName == "PrepareModeOdd" and not self.okai2 then
			self.animTime = self:getRealAnimationTime(self.animName);
			if self.animTime > 0 then
				Utils.setEmittingState(self.sParticles, true);
				self.okai2 = true;
			end;
		end;
			
		if self.animName ~= nil and self.animName == "PrepareModeOdd" and self.okai2 then
			self.animTime = self:getRealAnimationTime(self.animName);
			if self.animTime > 600 then
				Utils.setEmittingState(self.sParticles, false);
				self.okai2 = false;
			end;
		end;		
	end;
	
	if self.animName ~= nil and self.animName == "PrepareModeFull" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 0 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "PrepareModeFull" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 600 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;

	if self.animName ~= nil and (self.animName == self.loadEven2 or self.animName == self.loadEven4 or self.animName == self.loadEven6 or self.animName == self.loadEven8) and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 0 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and (self.animName == self.loadEven2 or self.animName == self.loadEven4 or self.animName == self.loadEven6 or self.animName == self.loadEven8) and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 2500 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;
	
	if self.animName ~= nil and (self.animName == self.loadEven2 or self.animName == self.loadEven4 or self.animName == self.loadEven6 or self.animName == self.loadEven8) and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 3000 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and (self.animName == self.loadEven2 or self.animName == self.loadEven4 or self.animName == self.loadEven6 or self.animName == self.loadEven8) and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 3600 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeOdd" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 0 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeOdd" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 200 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeOdd" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 225 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeOdd" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 249 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeFull" and not self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 0 then
			Utils.setEmittingState(self.sParticles, true);
			self.okai2 = true;
		end;
	end;
	
	if self.animName ~= nil and self.animName == "LoadModeFull" and self.okai2 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 5200 then
			Utils.setEmittingState(self.sParticles, false);
			self.okai2 = false;
		end;
	end;

	if self.animName == self.loadOdd and not self.itsOver then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 50 then
			self:MPCode(25, nil, self.state);
		end;
	end;
		
	if self.animName == self.loadFull and not self.itsOver then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 2500 then
			self:MPCode(25, nil, self.state);
		end;
	end;
		
	if self.animName == self.loadEven2 or self.animName == self.loadEven4 or self.animName == self.loadEven6 or self.animName == self.loadEven8 then
		self.animTime = self:getRealAnimationTime(self.animName);
		if self.animTime > 2500 and not self.itsOver then
			self:MPCode(25, nil, self.state);
		end;
	end;
		
	if not self.itsOver3 and (self.animName == self.preparefromFull or self.animName == self.preparefromEven or self.animName == self.preparefromOdd) then
		self.animTime = self:getAnimationTime(self.animName);
		if self.animTime >0.3 then
			self:MPCode(nil, nil, self.state);
		end;
	end;

	for i, v in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	
end;
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:FiDi(node,noEventSend)
	local x,y,z = localDirectionToWorld(node, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local JointDir = math.deg(math.atan2(dX,dZ)); 
	if JointDir < 0 then
		JointDir = 360 - (JointDir * -1);
	end;
	self.objDir = JointDir;

end;

--________________________________________________________________________________________________________________________________________________________
function Heath:FiHeBa(LoadJoint,noEventSend)
	
	local px, py, pz = getWorldTranslation(LoadJoint);
	local nearestDistance = 1;
	local nearestBale = nil;
	
	for index, item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then
			for i, baleType in pairs(self.baleTypes) do
				if getName(item.item.nodeId) == baleType then
					local bx, by, bz = getWorldTranslation(item.item.nodeId);
					local distance = Utils.vector3Length(px-bx, py-by, pz-bz);
					if distance < nearestDistance then
						self.baleId = item.item.nodeId;
						self:FiDi(self.baleId);
						self.baleDir = self.objDir;
						self:FiDi(LoadJoint);
						self.spikeDir = self.objDir;
						self.dif = self.spikeDir - self.baleDir;
						if math.abs(self.dif) <=45 or (180-math.abs(self.dif)) <=45 then
							self.foundIt = true;
							self.baleId = item.item.nodeId;
							self.fruitBale = baleType;
						else
							self.foundIt = false;
							self.baleId = nil;
							self.fruitBale = nil;
						end;
					end;
					break;
				end;
			end;
			if self.foundIt then
				break;
			end;
		end;
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.counter = Utils.getNoNil(getXMLInt(xmlFile, key.."#numBales"),0);
		if self.counter==2 or self.counter==3 then
		setTranslation(self.balesJoint, 0, 0.31, 3.02167);
	elseif self.counter==4 or self.counter==5 then
		setTranslation(self.balesJoint, 0, 0.22, 1.79341);
	elseif self.counter==6 or self.counter==7 then
		setTranslation(self.balesJoint, 0, 0.12, 0.57568);
	elseif self.counter==8 then
		setTranslation(self.balesJoint, 0, 0.04983, 0.03648);
	end;
		
		for i=1, 8 do
			local baleKey = key..string.format(".Bale(%d)", i-1);
			
			local vState = getXMLBool(xmlFile, baleKey.."#vState");
			setVisibility(self.hayBales[i], vState);
		end;
		
		for i=9, 16 do
			local baleKey = key..string.format(".Bale(%d)", i-1);
			
			local vState = getXMLBool(xmlFile, baleKey.."#vState");
			setVisibility(self.strawBales[i-8], vState);
		end;
		
	end;
	self.fillLevel = self.counter;
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:getSaveAttributesAndNodes(nodeIdent)

	local attributes = 'numBales="'..tostring(self.counter)..'"';
	
	local nodes = "";
	local baleCounter = 0;
	
	for i=1, 8 do
		local vState = getVisibility(self.hayBales[i]);
		if baleCounter>0 then
			nodes = nodes.."\n";
		end;
		if vState then
			nodes = nodes..nodeIdent..'<Bale vState="true" />';
		else
			nodes = nodes..nodeIdent..'<Bale vState="false" />';
		end;
		baleCounter = baleCounter +1;
	end;
	
	for i=1, 8 do
		local vState = getVisibility(self.strawBales[i]);
		if baleCounter>0 then
			nodes = nodes.."\n";
		end;
		if vState then
			nodes = nodes..nodeIdent..'<Bale vState="true" />';
		else
			nodes = nodes..nodeIdent..'<Bale vState="false" />';
		end;
		baleCounter = baleCounter +1;
	end;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:readStream(streamId, connection)

	self.animEnded = streamReadBool(streamId);
	self.unloadMode = streamReadBool(streamId);
	self.unloaded = streamReadBool(streamId);
	self.abort = streamReadBool(streamId);
	self.workMode = streamReadBool(streamId);
	self.endGame = streamReadBool(streamId);
	self.ready2go = streamReadBool(streamId);
	self.prepareMode = streamReadBool(streamId);
	self.okai = streamReadBool(streamId);
	self.okai2 = streamReadBool(streamId);
	self.okai3 = streamReadBool(streamId);
	
	self.itsOver = streamReadBool(streamId);
	self.itsOver2 = streamReadBool(streamId);
	self.itsOver3 = streamReadBool(streamId);
	self.tranprep = streamReadBool(streamId);
	
	self.counter = streamReadInt32(streamId);
	self.animName = streamReadString(streamId);
	self.animTime = streamReadFloat32(streamId);
	self.fruitBale = streamReadString(streamId);
	
	for i=1, 8 do
		local vhState = streamReadBool(streamId);
		setVisibility(self.hayBales[i], vhState);
	end;
	
	for i=1, 8 do
		local vsState = streamReadBool(streamId);
		setVisibility(self.strawBales[i], vsState);
	end;
	
	if self.counter==2 or self.counter==3 then
		setTranslation(self.balesJoint, 0, 0.31, 3.02167);
	elseif self.counter==4 or self.counter==5 then
		setTranslation(self.balesJoint, 0, 0.22, 1.79341);
	elseif self.counter==6 or self.counter==7 then
		setTranslation(self.balesJoint, 0, 0.12, 0.57568);
	elseif self.counter==8 then
		setTranslation(self.balesJoint, 0, 0.04983, 0.03648);
	end;
	
	if math.mod(self.counter, 2) == 0 and self.counter ~= 8 and self.counter ~= 0 then
		self:playAnimation(self.loadEven, 1, nil, true);
		AnimatedVehicle.updateAnimations(self, 99999999);
	elseif self.counter == 8 then
		self:playAnimation(self.loadFull, 1, nil, true);
		AnimatedVehicle.updateAnimations(self, 99999999);
	end;

	for name,v in pairs(self.animations) do
		if self.activeAnimations[name] ~= nil then
			self:playAnimation(name, 1, nil, true);
			AnimatedVehicle.updateAnimations(self, 99999999);
		end;
	end;
	
	self.fillLevel = streamReadFloat32(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function Heath:writeStream(streamId, connection)
	
	streamWriteBool(streamId, self.animEnded);
    streamWriteBool(streamId, self.unloadMode);
	streamWriteBool(streamId, self.unloaded);
	streamWriteBool(streamId, self.abort);
	streamWriteBool(streamId, self.workMode);
	streamWriteBool(streamId, self.endGame);
	streamWriteBool(streamId, self.ready2go);
	streamWriteBool(streamId, self.prepareMode);

	streamWriteBool(streamId, self.okai);
	streamWriteBool(streamId, self.okai2);
	streamWriteBool(streamId, self.okai3);
	
	streamWriteBool(streamId, self.itsOver);
	streamWriteBool(streamId, self.itsOver2);
	streamWriteBool(streamId, self.itsOver3);
	streamWriteBool(streamId, self.tranprep);
	streamWriteInt32(streamId, self.counter);
	
	streamWriteString(streamId, self.animName);
	streamWriteFloat32(streamId, self.animTime);
	streamWriteString(streamId, self.fruitBale);

	for i=1, 8 do
		local vhState = getVisibility(self.hayBales[i]);
		streamWriteBool(streamId, vhState);
	end;
	
	for i=1, 8 do
		local vsState = getVisibility(self.strawBales[i]);
		streamWriteBool(streamId, vsState);
	end;
	
	streamWriteFloat32(streamId, self.fillLevel);
end;