--
-- twoAttacherJoints
-- Specialization for twoAttacherJoints
--
-- @author  PeterJ - euroDZN
-- @date  06/06/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

twoAttacherJoints = {};

function twoAttacherJoints.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;


function twoAttacherJoints:load(xmlFile)
	
	self.getJointTypeInRange = SpecializationUtil.callSpecializationsFunction("getJointTypeInRange");
	
	self.attacherJointNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint.secondAttacher#index"));
	if self.attacherJointNode2 ~= nil then
		self.jointTypeStr2 = getXMLString(xmlFile, "vehicle.attacherJoint.secondAttacher#jointType")
		if self.jointTypeStr2 ~= nil then
			self.jointType2 = Vehicle.jointTypeNameToInt[self.jointTypeStr2];
			if self.jointType2 == nil then
				print("Warning: invalid jointType " .. jointTypeStr2);
			end;
			self.jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint#jointType")
			self.jointType = Vehicle.jointTypeNameToInt[self.jointTypeStr];
			self.attacherJointNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
		end;
	end;
	
	self.schemaOverlayFile = getXMLString(xmlFile, "vehicle.schemaOverlay.firstAttacher#file");
	self.schemaOverlayFileSelected = getXMLString(xmlFile, "vehicle.schemaOverlay.firstAttacher#fileSelected");
	local x, y = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.schemaOverlay.firstAttacher#attacherJointPosition"));
	self.schemaOverlayX = x;
	self.schemaOverlayY = y;
	
	self.schemaOverlay1 = self.schemaOverlay;
	
	local schemaOverlayFile = getXMLString(xmlFile, "vehicle.schemaOverlay.secondAttacher#file");
	if schemaOverlayFile ~= nil then
		schemaOverlayFile = Utils.getFilename(schemaOverlayFile, self.baseDirectory);
		local width = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.schemaOverlay.secondAttacher#width"), 1) * g_currentMission.vehicleSchemaOverlayScaleX;
		local height = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.schemaOverlay.secondAttacher#height"), 1) * g_currentMission.vehicleSchemaOverlayScaleY;
		local invisibleBorderRight = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.schemaOverlay.secondAttacher#invisibleBorderRight"), 0.05);
		local invisibleBorderLeft = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.schemaOverlay.secondAttacher#invisibleBorderLeft"), 0.05);
		local x, y = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.schemaOverlay.secondAttacher#attacherJointPosition"));
		local baseX, baseY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.schemaOverlay.secondAttacher#basePosition"));
		if baseX == nil then
			baseX = x;
		end;
		if baseY == nil then
			baseY = y;
		end;
		if x ~= nil and y ~= nil then
			local overlay = Overlay:new("", schemaOverlayFile, 0,0, width, height);
			local schemaOverlayFileSelected = getXMLString(xmlFile, "vehicle.schemaOverlay.secondAttacher#fileSelected");
			local overlaySelected = overlay;
			if schemaOverlayFileSelected ~= nil then
				schemaOverlayFileSelected = Utils.getFilename(schemaOverlayFileSelected, self.baseDirectory);
				overlaySelected = Overlay:new("", schemaOverlayFileSelected, 0,0, width, height);
			end;
			self.schemaOverlay2 = {overlay=overlay, overlaySelected=overlaySelected, x=x, y=y, baseX=baseX, baseY=baseY, invisibleBorderRight=invisibleBorderRight,invisibleBorderLeft=invisibleBorderLeft};
		end;
	end;
	
end;

function twoAttacherJoints:delete()
end;
  
function twoAttacherJoints:readStream(streamId, connection)
end;

function twoAttacherJoints:writeStream(streamId, connection)
end;

function twoAttacherJoints:mouseEvent(posX, posY, isDown, isUp, button)
end;

function twoAttacherJoints:keyEvent(unicode, sym, modifier, isDown)
end;

function twoAttacherJoints:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local secondJointType = getXMLBool(xmlFile, key.."#secondJoint");
		if secondJointType ~= nil then
			if secondJointType then
				if self.attacherJoint.jointType == self.jointType then
					self.attacherJoint.node = self.attacherJointNode2;
					self.attacherJoint.jointType = self.jointType2;
					self.schemaOverlay = self.schemaOverlay2;
					self.secondJointType = true;
				end;
			end;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function twoAttacherJoints:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'secondJoint="'..tostring(self.secondJointType)..'"';
	return attributes, nil;
end;

function twoAttacherJoints:update(dt)
	if not self:getIsActive() then
		if not self.implementMounted then
			self:getJointTypeInRange()
			if self.secondJointType then
				if self.attacherJoint.jointType == self.jointType then
					self.attacherJoint.node = self.attacherJointNode2;
					self.attacherJoint.jointType = self.jointType2;
					self.schemaOverlay = self.schemaOverlay2;
				end;
			else
				if self.attacherJoint.jointType == self.jointType2 then
					self.attacherJoint.node = self.attacherJointNode;
					self.attacherJoint.jointType = self.jointType;
					self.schemaOverlay = self.schemaOverlay1;
				end;
			end;
		end;
	end;
end;

function twoAttacherJoints:updateTick(dt)
end;

function twoAttacherJoints:draw()
end;

function twoAttacherJoints:onAttach()
	self.implementMounted = true;
end; 	

function twoAttacherJoints:onDetach()
	self.implementMounted = false;
end;

function twoAttacherJoints:getJointTypeInRange()
	local jointDistance = 0.95;
	local px, py, pz = getWorldTranslation(self.attacherJointNode);
	for k,v in pairs(g_currentMission.steerables) do
		if v.attacherJoints ~= nil then
			local dx, dy, dz = getWorldTranslation(v.components[1].node);
			local vehicleDist = Utils.vector3Length(px-dx, py-dy, pz-dz);
			if vehicleDist < 4 then
				for _, jointNode in pairs(v.attacherJoints) do
					if jointNode.jointTransform ~= nil then
						if jointNode.jointType == self.jointType2 then
							local tx, ty, tz = getWorldTranslation(jointNode.jointTransform);
							local distance = Utils.vector3Length(px-tx, py-ty, pz-tz);
							if distance < jointDistance then
								self.secondJointType = true;
							else
								self.secondJointType = false;
							end;
						end;
					end;
				end;
			end;
		end;
    end;
end;
