--
-- handlerAnimation
-- Class for handlers
--
-- @authorPeterJ - euroDZN
-- @date 29/09/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

handlerAnimation = {};

function handlerAnimation.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function handlerAnimation:load(xmlFile)

	self.setOperateAnim = SpecializationUtil.callSpecializationsFunction("setOperateAnim");
	self.handlerAnimation = getXMLString(xmlFile, "vehicle.handlerAnim#animationName");
	self.isHandlerAnimOn = false;
	
	self.frameNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.handlerAnim#frameNode"));
	self.animInfo = getXMLString(xmlFile, "vehicle.handlerAnim#animInfo");
	
end;

function handlerAnimation:delete()
end;

function handlerAnimation:readStream(streamId, connection)
	self:setOperateAnim(streamReadBool(streamId), true);
end;

function handlerAnimation:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isHandlerAnimOn);
end;

function handlerAnimation:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local animOn = getXMLBool(xmlFile, key.."#handlerAnimOn");
		if animOn ~= nil then
			self:setOperateAnim(animOn);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function handlerAnimation:getSaveAttributesAndNodes(nodeIdent)
	if self.handlerAnimation ~= nil then
		local attributes = 'handlerAnimOn="'..tostring(self.isHandlerAnimOn)..'"';
		return attributes, nil;
	end;
end;

function handlerAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function handlerAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function handlerAnimation:update(dt)
	if not self:getIsActive() then
		if self.playerInNodeRange and not self.isBaleAttach then
			g_currentMission:addHelpButtonText(g_i18n:getText(self.animInfo), InputBinding.IMPLEMENT_EXTRA3);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setOperateAnim(not self.isHandlerAnimOn);
			end;
		end;
	end;
end;

function handlerAnimation:updateTick(dt)

	if g_currentMission.player ~= nil and self.frameNode ~= nil then
		local nearestDistance = 1.75;
		local x1,y1,z1 = getWorldTranslation(self.frameNode);
		local x3,y3,z3 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x3,y1-y3,z1-z3);
		if distance < nearestDistance then
			self.playerInNodeRange = true;
		else
			self.playerInNodeRange = false; 
		end;
	end;
end;

function handlerAnimation:draw()
end;

function handlerAnimation:setOperateAnim(isHandlerAnimOn,noEventSend)
	setFrameAnimEvent.sendEvent(self, isHandlerAnimOn, noEventSend);

	self.isHandlerAnimOn = isHandlerAnimOn;
	if self.isHandlerAnimOn then
		if self.handlerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.handlerAnimation, 1, nil, true);
		end;
	else
		if self.handlerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.handlerAnimation, -1, nil, true);
		end;
	end;
	setVisibility(self.frameNode, not self.isHandlerAnimOn);
end;

setFrameAnimEvent = {};
setFrameAnimEvent_mt = Class(setFrameAnimEvent, Event);

InitEventClass(setFrameAnimEvent, "setFrameAnimEvent");

function setFrameAnimEvent:emptyNew()
	local self = Event:new(setFrameAnimEvent_mt);
	self.className="setFrameAnimEvent";
	return self;
end;

function setFrameAnimEvent:new(vehicle, isHandlerAnimOn)
	local self = setFrameAnimEvent:emptyNew()
	self.vehicle = vehicle;
	self.isHandlerAnimOn = isHandlerAnimOn;
	return self;
end;

function setFrameAnimEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isHandlerAnimOn = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function setFrameAnimEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isHandlerAnimOn);
end;

function setFrameAnimEvent:run(connection) 
	self.vehicle:setOperateAnim(self.isHandlerAnimOn, true);
	if not connection:getIsServer() then
	g_server:broadcastEvent(setFrameAnimEvent:new(self.vehicle, self.isHandlerAnimOn), nil, connection, self.vehicle);
	end;
end;

function setFrameAnimEvent.sendEvent(vehicle, isHandlerAnimOn, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setFrameAnimEvent:new(vehicle, isHandlerAnimOn), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setFrameAnimEvent:new(vehicle, isHandlerAnimOn));
		end;
	end;
end;