--
-- baleLockByMovement
-- Specialization for attaching bales on a trailer
--
-- @author Geri-G
--
-- edited by PeterJ - euroDZN 
-- 16/11/2012
-- 05/06/2013 - made controllable by movement 
--

baleLockByMovement = {};

function baleLockByMovement.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function baleLockByMovement:load(xmlFile)

	self.setIsBaleAttached = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached");
	self.searchBales = baleLockByMovement.searchBales;
	self.attachbales = baleLockByMovement.attachbales;
	self.detachbales = baleLockByMovement.detachbales;
	self.OrientJoint = baleLockByMovement.OrientJoint;
	self.isBaleInRange = baleLockByMovement.isBaleInRange;
	
	self.place = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints.baleCastPoint(%d)",i);
		local place = {};
		place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight"));

		if place.node1 == nil then
			break;
		end;
		place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft"));
		place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode"),"0>"));
		local highOffsetNode = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#highOffsetNode"));
		if highOffsetNode ~= nil then
			place.highOffsetNode = highOffsetNode;
			place.highOffset = nil;
		else
			place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset"),4);
		end;
		table.insert(self.place,place);
		i=i+1;
	end;
	self.Attachedbales = {};
	self.isBaleAttach = false;
	
	self.controlledByKey = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.baleCastPoints#controlledByKey"), true)
	if not self.controlledByKey then
		self.animLockTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.baleCastPoints#animLockTime"), (self.animationParts[1].animDuration/2));
	end;

end;

function baleLockByMovement:delete()
end;

function baleLockByMovement:readStream(streamId, connection)
	local baleAttach = streamReadBool(streamId);
	self:setIsBaleAttached(baleAttach, true);			
end;

function baleLockByMovement:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isBaleAttach);
end;

function baleLockByMovement:keyEvent(unicode, sym, modifier, isDown)
end;

function baleLockByMovement:mouseEvent(posX, posY, isDown, isUp, button)
end;

function baleLockByMovement:update(dt)
	if self:getIsActive() then
		if self.controlledByKey then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setIsBaleAttached(not self.isBaleAttach);
				end;
			end;
		end;
	end;
end;

function baleLockByMovement:updateTick(dt)

	if self:getIsActive() then
		if not self.controlledByKey then
			local animTime = self.animationParts[1].inputTime;
			if animTime ~= nil then
				if self.isBaleAttach then
					if self.animLockTime > animTime then
						self:setIsBaleAttached(false);				
					end;
				else
					if self.animLockTime < animTime then
						self:setIsBaleAttached(true);				
					end;
				end;
			end;
		end;
	end;
end;

function baleLockByMovement:draw()
	if self:getIsActive() then
		if self.controlledByKey then
			if self.isBaleAttach then
				g_currentMission:addHelpButtonText(g_i18n:getText("Unlock"), InputBinding.IMPLEMENT_EXTRA3);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("Lock"), InputBinding.IMPLEMENT_EXTRA3);
			end;
		else
			if self.isBaleAttach then
				if self.isBaleAttach2 == nil then
					g_currentMission:addExtraPrintText(g_i18n:getText("BaleLocked"));
				else
					g_currentMission:addExtraPrintText(g_i18n:getText("Locked1"));
				end;
			end;
		end;
	end;
end;

function baleLockByMovement:isBaleInRange(place,bale)
	local Xmax, Ymax, Zmax = getWorldTranslation(place.node1);
		  Xmax, Ymax, Zmax = worldToLocal(place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(place.node2);	
		  Xmin, Ymin, Zmin = worldToLocal(place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(bale);
		  Xt, Yt, Zt = worldToLocal(place.attacherNode,Xt, Yt, Zt);
		
	local highOffset = nil;
	if place.highOffsetNode ~= nil then
		local x, y, z = getTranslation(place.node1)
		local x1, y2, z3 = getTranslation(place.node2)
		local _, yOffset, _ = getTranslation(place.highOffsetNode);
		highOffset = ((y-y2)/2) + yOffset;
		place.highOffset = highOffset;
	end;
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+place.highOffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;

function baleLockByMovement:searchBales()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 
			if item.item.isAttached == nil then--and (getUserAttribute(item.item.nodeId, "isHaybale") == true or getUserAttribute(item.item.nodeId, "isStrawbale") == true or getUserAttribute(item.item.nodeId, "isRoundbale") == true) then
				for k,v in pairs(self.place) do
					local isInRange = self:isBaleInRange(v,item.item.nodeId);			
					local is1stAttached = false;
					if isInRange then
						is1stAttached = self:attachbales(v,item.item.nodeId,item.item);
					end;
				end;
			end;
		end;
	end;
end;

function baleLockByMovement:setIsBaleAttached(baleAttach, noEventSend)
	SetBaleAttachEvent.sendEvent(self, baleAttach, noEventSend)
	self.isBaleAttach = baleAttach;
	
	if baleAttach then
		self:searchBales();	
	else
		self:detachbales();
	end;
end;

function baleLockByMovement:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function baleLockByMovement:attachbales(place,bale,baleT)
	local attachedbale = {};
	attachedbale.bale = bale;
	if self.isServer then
		attachedbale.AT = createTransformGroup("AT");
		link(place.attacherNode,attachedbale.AT);
		
		self:OrientJoint(bale,attachedbale.AT);

		local constr = JointConstructor:new();					
		constr:setActors(place.attacherNode, bale);
		constr:setJointTransforms(attachedbale.AT,  bale);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedbale.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedbale.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedbales, attachedbale);
	return true;
end;

function baleLockByMovement:detachbales()
	if self.isServer then
		for k,v in pairs(self.Attachedbales) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedbales = nil;
	self.Attachedbales = {};
end;

function baleLockByMovement:onAttach(attacherVehicle)
	if self.isServer then
		--self:setIsBaleAttached(true);
	end;
end;

function baleLockByMovement:onDetach()
	if self.isServer then
		self:setIsBaleAttached(false);
	end;
end;



SetBaleAttachEvent = {};
SetBaleAttachEvent_mt = Class(SetBaleAttachEvent, Event);
  
InitEventClass(SetBaleAttachEvent, "SetBaleAttachEvent");
  
function SetBaleAttachEvent:emptyNew()
	local self = Event:new(SetBaleAttachEvent_mt);
	self.className="SetBaleAttachEvent";
	return self;
end;
  
function SetBaleAttachEvent:new(bale, baleAttach)
      local self = SetBaleAttachEvent:emptyNew()
      self.bale = bale;
      self.baleAttach = baleAttach;
      return self;
end;
  
function SetBaleAttachEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.baleAttach = streamReadBool(streamId);
	self.bale = networkGetObject(id);
	self:run(connection);
end;
  
function SetBaleAttachEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.bale));
	streamWriteBool(streamId, self.baleAttach);
end;
  
function SetBaleAttachEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.bale);
	end;
	self.bale:setIsBaleAttached(self.baleAttach, true);
end;
  
function SetBaleAttachEvent.sendEvent(vehicle, baleAttach, noEventSend)
	if baleAttach ~= vehicle.isBaleAttach then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetBaleAttachEvent:new(vehicle, baleAttach), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetBaleAttachEvent:new(vehicle, baleAttach));
			end;
		end;
	end;
end;

