SetEmptyBalerEvent = {};
SetEmptyBalerEvent_mt = Class(SetEmptyBalerEvent, Event);

InitEventClass(SetEmptyBalerEvent, "SetEmptyBalerEvent");

function SetEmptyBalerEvent:emptyNew()
    local self = Event:new(SetEmptyBalerEvent_mt);
    self.className="SetEmptyBalerEvent";
    return self;
end;

function SetEmptyBalerEvent:new(vehicle, state)
    local self = SetEmptyBalerEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetEmptyBalerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetEmptyBalerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetEmptyBalerEvent:run(connection)
	self.vehicle:emptyBaler(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetEmptyBalerEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetEmptyBalerEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetEmptyBalerEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetEmptyBalerEvent:new(vehicle, state));
		end;
	end;
end;