--
--	RealLights
--
--	This script adds real flashing blinkers to your vehicle	
--	therefore you need to use the correct shader in the material
--		--> blinkingEmissiveBillboardShader.xml 
--	
--	Reverse and brake lights are also possible 
--		--> fadingEmissiveBillboardShader.xml
--
--	Example entry for a vehicle.xml:
--	NOTE: 	- you can use multipe index-entries for any type of light
--			- be aware of the nomenclature
--	<realLights>
--		<blinkLeft index1="23|7|0" index2="23|7|1" />
--		<blinkRight index1="23|6|0" index2="23|6|1" />
--		<reverse index1="23|3|0" index2="23|3|1" />
--		<brake index1="23|5|0" index2="23|5|1" />
--	</realLights>
--
--	version: 		0.2
--	last edit:		12.02.2013
--	inspired by:	GIANTS
--	written by: 	fruktor
-- 	powered by: 	www.eifok-team.de
--	copyright:		you don't need to edit this file!
--


RealLights = {};

local mod_directory = g_currentModDirectory;
source(Utils.getFilename("SetRealLight_BlinkerLEvent.lua", mod_directory));
source(Utils.getFilename("SetRealLight_BlinkerWEvent.lua", mod_directory));
source(Utils.getFilename("SetRealLight_BlinkerREvent.lua", mod_directory));
source(Utils.getFilename("SetRealLight_BrakeIsPressedEvent.lua", mod_directory));

function RealLights.prerequisitesPresent(specializations)
    return true;
end;

function RealLights:load(xmlFile)	

	-- 
	self.setBlinkerLState = SpecializationUtil.callSpecializationsFunction("setBlinkerLState");
	self.setBlinkerRState = SpecializationUtil.callSpecializationsFunction("setBlinkerRState");
	self.setBlinkerWState = SpecializationUtil.callSpecializationsFunction("setBlinkerWState");
	
	self.setReverseState = SpecializationUtil.callSpecializationsFunction("setReverseState");

	self.setBrakeState = SpecializationUtil.callSpecializationsFunction("setBrakeState");
	self.setBrakeIsPressed = SpecializationUtil.callSpecializationsFunction("setBrakeIsPressed");

	self.isBrakePressed = false;
	
	self.rLights = {};
	
	self.rLights.a = false;
	
	self.rLights.isMaster = SpecializationUtil.hasSpecialization(Steerable, self.specializations);
	self.rLights.steerThresh = 0.7;
	
	self.rLights.blw = {};
	self.rLights.blw.a = false;
	
	self.rLights.bll = {};
	self.rLights.bll.nodes = {};
	self.rLights.bll.a = false;
	local r=1;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.realLights.blinkLeft#index%d",r)) );
		if node == nil then
			break;
		end;
		table.insert(self.rLights.bll.nodes, node);
		self.rLights.a = true;
		setVisibility( node, false );
		r = r+1;
	end
	
	self.rLights.blr = {};
	self.rLights.blr.nodes = {};
	self.rLights.blr.a = false;
	local r=1;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.realLights.blinkRight#index%d",r)) );
		if node == nil then
			break;
		end;
		table.insert(self.rLights.blr.nodes, node);
		self.rLights.a = true;
		setVisibility( node, false );
		r = r+1;
	end
	
	self.rLights.rev = {};
	self.rLights.rev.nodes = {};
	self.rLights.rev.v = 0.0;
	self.rLights.rev.vOld = 0.0;
	local r=1;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.realLights.reverse#index%d",r)) );
		if node == nil then
			break;
		end;
		table.insert(self.rLights.rev.nodes, node);
		self.rLights.a = true;
		setVisibility( node, false );
		r = r+1;
	end
	
	self.rLights.bra = {};
	self.rLights.bra.nodes = {};
	self.rLights.bra.v = 0.0;
	self.rLights.bra.vOld = 0.0;
	local r=1;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.realLights.brake#index%d",r)) );
		if node == nil then
			break;
		end;
		table.insert(self.rLights.bra.nodes, node);
		self.rLights.a = true;
		setVisibility( node, false );
		r = r+1;
	end
	

end;


function RealLights:delete()
end;


function RealLights:readStream(streamId, connection)
end;


function RealLights:writeStream(streamId, connection)	
end;


function RealLights:mouseEvent(posX, posY, isDown, isUp, button)
end;


function RealLights:keyEvent(unicode, sym, modifier, isDown)
end;


function RealLights:update(dt)

	if not self.rLights.a then
		return;
	end;


	if Vehicle.debugRendering then

	end;		
	
	
	if self.rLights.attVeh ~= nil then
		local attacherVehicle = self.rLights.attVeh;
		while attacherVehicle.attacherVehicle ~= nil do 
			attacherVehicle = attacherVehicle.attacherVehicle;
		end
		if SpecializationUtil.hasSpecialization(Steerable, attacherVehicle.specializations) then
			self.rLights.attVeh = attacherVehicle;
		end;	
	end;
	
	--###
	if self:getIsActive() and self.rLights.isMaster then
		
		--#
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if self.rLights.blw.a == false then
				if InputBinding.hasEvent(InputBinding.REALLIGHTS_BLINKL) then
					if self.rLights.blr.a and self.rLights.bll.a == false then
						self:setBlinkerRState(false);
					end
					self:setBlinkerLState(not self.rLights.bll.a);
				elseif InputBinding.hasEvent(InputBinding.REALLIGHTS_BLINKR) then
					if self.rLights.bll.a and self.rLights.blr.a == false then
						self:setBlinkerLState(false);
					end
					self:setBlinkerRState(not self.rLights.blr.a);
				end
			end
			if InputBinding.hasEvent(InputBinding.REALLIGHTS_BLINKW) then
				self:setBlinkerWState(not self.rLights.blw.a );
			end;	
		end;
	end;

end;
	
	
function RealLights:updateTick(dt)

	if not self.rLights.a then
		return;
	end;
	
	--#
	if self.rLights.isMaster then
	
		if self:getIsActive() and self:getIsActiveForInput(false) then
		
			if self.isClient then
					
				local axisForward = 0;
				axisForward = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
				if InputBinding.isAxisZero(axisForward) then
					axisForward = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE)
				end;

				--print("axisForward="..tostring(axisForward).." self.movingDirection="..tostring(self.movingDirection).." "..tostring(self.lastSpeed).."   self.lastSpeedReal="..tostring(self.lastSpeedReal));

				isBrakePressed = false;
				if self.movingDirection > 0 and axisForward > 0 then
					isBrakePressed = true;
				elseif self.movingDirection < 0 and axisForward < 0 then
					isBrakePressed = true;
				end;
				
				if self.isBrakePressed ~= isBrakePressed then 
					self:setBrakeIsPressed(isBrakePressed);
				end;

			end;
		
		end;

	end;
		
		
	--#
	if true then --self:getIsActive() then
	
		local fac = 3.5;		
		
		if self.isServer then
			
			--print("self.movingDirection="..tostring(self.movingDirection).."   self.lastAcceleration="..tostring(self.lastAcceleration).."   self.lastSpeed="..tostring(self.lastSpeed)"   self.lastSpeedReal="..tostring(self.lastSpeedReal));
			
			if self.rLights.isMaster then
			
				-- disable? blinker
				if self.rLights.blw.a == false then
					--self.rLightsSteerThreshReached = false;
					if math.abs(self.rotatedTime/self.maxRotTime) > self.rLights.steerThresh then
						self.rLightsSteerThreshReached = true;
					end;					
					if self.rLightsSteerThreshReached == true and math.abs(self.rotatedTime/self.maxRotTime) < self.rLights.steerThresh/10 then
						if self.rLightsSteerThreshReached and self.rLights.bll.a then
							self.rLightsSteerThreshReached = false;
							self:setBlinkerLState(false);
						elseif self.rLightsSteerThreshReached and self.rLights.blr.a then
							self.rLightsSteerThreshReached = false;
							self:setBlinkerRState(false);
						end;
						self.rLightsSteerThreshReached = false;
					end;
				end;
				
			end;
			
		end;
			
			
		if self.isClient then			
			
			if not self.rLights.isMaster then
				
				if self.rLights.attVeh ~= nil then
					
					-- Master has realLights
					if self.rLights.attVeh.rLights ~= nil then
						--print("11");
						
						if self.rLights.attVeh.rLights.a == true then 
							--print("111");
							if self.rLights.bll.a ~= self.rLights.attVeh.rLights.bll.a then
								self:setBlinkerLState(self.rLights.attVeh.rLights.bll.a, true);
							end
							if self.rLights.blr.a ~= self.rLights.attVeh.rLights.blr.a then
								self:setBlinkerRState(self.rLights.attVeh.rLights.blr.a, true);
							end
							if self.rLights.rev.v ~= self.rLights.attVeh.rLights.rev.v then
								self:setReverseState(self.rLights.attVeh.rLights.rev.v);
							end
							if self.rLights.bra.v ~= self.rLights.attVeh.rLights.bra.v then
								self:setBrakeState(self.rLights.attVeh.rLights.bra.v);
							end
							
						else
						
							if self.rLights.attVeh.brakeLightsVisibility ~= nil then
								local a = self.rLights.attVeh.brakeLightsVisibility;
								if a == true then
									if self.isBrakePressed == false then
										self:setBrakeIsPressed(true);									
									end;
								else						
									if self.isBrakePressed == true then									
										self:setBrakeIsPressed(false);									
									end;
								end;
							end;
							
						end;
						
					-- Master has BELv3
					elseif self.rLights.attVeh.B3 ~= nil then
						--print("12");
						
						if self.rLights.attVeh.B3.dirLeft ~= nil then
							if self.rLights.attVeh.B3.dirLeft[1] ~= nil then
								if self.rLights.bll.a ~= self.rLights.attVeh.B3.dirLeft[1].a then
									self:setBlinkerLState(self.rLights.attVeh.B3.dirLeft[1].a, true);
								end
							end
						end
						if self.rLights.attVeh.B3.dirRight ~= nil then														
							if self.rLights.attVeh.B3.dirRight[1] ~= nil then														
								if self.rLights.blr.a ~= self.rLights.attVeh.B3.dirRight[1].a then
									self:setBlinkerRState(self.rLights.attVeh.B3.dirRight[1].a, true);
								end
							end
						end

						--[[
						if self.rLights.attVeh.B3.reverse ~= nil then
							if self.rLights.attVeh.B3.reverse[1].a ~= nil then
								if self.rLights.attVeh.B3.reverse[1].a == true then
									self.rLights.rev.v = math.min(1.0, self.rLights.rev.v + dt*0.001*fac);
									if self.rLights.rev.v ~= self.rLights.rev.vOld then
										self.rLights.rev.vOld = self.rLights.rev.v;
										self:setReverseState( self.rLights.rev.v );
									end									
								else
									self.rLights.rev.v = math.max(0.0, self.rLights.rev.v - dt*0.001*fac);
									if self.rLights.rev.v ~= self.rLights.rev.vOld then
										self.rLights.rev.vOld = self.rLights.rev.v;
										self:setReverseState( self.rLights.rev.v );
									end						
								end
							end;
						end;
						]]--
						
						if self.rLights.attVeh.brakeLights ~= nil then
							if self.rLights.attVeh.brakeLights[1] ~= nil then
								local a = getVisibility(self.rLights.attVeh.brakeLights[1]);
								if a == true then
									if self.isBrakePressed == false then
										self:setBrakeIsPressed(true);									
									end;
								else
									if self.isBrakePressed == true then
										self:setBrakeIsPressed(false);									
									end;
								end;
							end
						end;						
					
					-- Master has only default lights
					else	-- only brakes
						--print("13");
						
						if self.rLights.attVeh.brakeLightsVisibility ~= nil then
							local a = self.rLights.attVeh.brakeLightsVisibility;
							if a == true then
								if self.isBrakePressed == false then
									self:setBrakeIsPressed(true);								
								end;
							else
								if self.isBrakePressed == true then
									self:setBrakeIsPressed(false);									
								end;
							end;
						end;
						
					end;
					
				end;		
				
			end;
			
		end;
		
	else 		-- disable lights, when not active ?!
			
	end;	
	
	
	
	--# updates local (visible) states for brake and reverse
	if self.isClient then
	
		local fac = 3.5;
	
		if self.isBrakePressed then
			local state = math.min(1.0, self.rLights.bra.v + dt*0.001*fac);
			if state ~= self.rLights.bra.vOld then
				self.rLights.bra.vOld = state;
				self.rLights.bra.v = state;
				self:setBrakeState( state );
			end
		else
			local state = math.max(0.0, self.rLights.bra.v - dt*0.001*fac);
			if state ~= self.rLights.bra.vOld then
				self.rLights.bra.vOld = state;
				self.rLights.bra.v = state;
				self:setBrakeState( state );
			end
		end;	
		
		if self.movingDirection < 0 then -- or self.lastAcceleration < 0 then
			self.rLights.rev.v = math.min(1.0, self.rLights.rev.v + dt*0.001*fac);
			if self.rLights.rev.v ~= self.rLights.rev.vOld then
				self.rLights.rev.vOld = self.rLights.rev.v;
				self:setReverseState( self.rLights.rev.v );
			end
		else
			self.rLights.rev.v = math.max(0.0, self.rLights.rev.v - dt*0.001*fac);
			if self.rLights.rev.v ~= self.rLights.rev.vOld then
				self.rLights.rev.vOld = self.rLights.rev.v;
				self:setReverseState( self.rLights.rev.v );
			end
		end;		
		
	
	end;
	
end;


function RealLights:draw()
end;


function RealLights:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;	
end;


function RealLights:getSaveAttributesAndNodes(nodeIdent)
    local attributes = '';
    return attributes, nil;
end;


function RealLights:onAttach(attacherVehicle)
	while attacherVehicle.attacherVehicle ~= nil do 
		attacherVehicle = attacherVehicle.attacherVehicle;
	end
	if SpecializationUtil.hasSpecialization(Steerable, attacherVehicle.specializations) then
		self.rLights.attVeh = attacherVehicle;
		--if attacherVehicle.rLights ~= nil then
		--	self.rLights.attVeh = attacherVehicle;
		--elseif attacherVehicle.B3 ~= nil then
		--	self.rLights.attVeh = attacherVehicle;
		--else
		--	self.rLights.attVeh = nil;
		--end;
	end;
end;


function RealLights:onDetach()
	self.rLights.attVeh = nil;
	self.isBrakePressed = false;
end;


function RealLights:attachImplement(object, jointIndex, noEventSend, index)
end;


function RealLights:detachImplement(implementIndex, noEventSend)
end



function RealLights:setBlinkerLState(state, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setBlinkerLState("..tostring(state)..", "..tostring(noEventSend));
	SetRealLight_BlinkerLEvent.sendEvent(self, state, noEventSend);
	self.rLights.bll.a = state;
	if self.isClient then
		if state == true then
			for i,n in pairs(self.rLights.bll.nodes) do
				setVisibility(n, true);
				setShaderParameter(n, "offsetFreqMinMax", 0, 1.2, 0, 1, false);	
			end;	
		else
			for i,n in pairs(self.rLights.bll.nodes) do
				setVisibility(n, false);
			end;	
		end;
	end;
end;

function RealLights:setBlinkerRState(state, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setBlinkerRState("..tostring(state)..", "..tostring(noEventSend));
	SetRealLight_BlinkerREvent.sendEvent(self, state, noEventSend);
	self.rLights.blr.a = state;
	if self.isClient then
		if state == true then
			for i,n in pairs(self.rLights.blr.nodes) do
				setVisibility(n, true);
				setShaderParameter(n, "offsetFreqMinMax", 0, 1.2, 0, 1, false);	
			end;	
		else
			for i,n in pairs(self.rLights.blr.nodes) do
				setVisibility(n, false);
			end;	
		end;
	end;
end;

function RealLights:setBlinkerWState(state, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setBlinkerWState("..tostring(state)..", "..tostring(noEventSend));
	SetRealLight_BlinkerWEvent.sendEvent(self, state, noEventSend);
	self.rLights.blw.a = state;
	self:setBlinkerLState(state, noEventSend);
	self:setBlinkerRState(state, noEventSend);
end;

function RealLights:setReverseState(value, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setReverseState("..tostring(value)..", "..tostring(noEventSend));
	--SetRealLight_ReverseEvent.sendEvent(self, value, noEventSend);	
	--self.rLights.rev.v = value;
	if self.isClient then
		for i,n in pairs(self.rLights.rev.nodes) do
			setShaderParameter(n, "offsetDir", value, 0, 0, 0, false);
		end;	
		if value > 0 then
			for i,n in pairs(self.rLights.rev.nodes) do
				setVisibility(n, true);
			end;	
		else
			for i,n in pairs(self.rLights.rev.nodes) do
				setVisibility(n, false);
			end;	
		end; 	
	end;
end;


function RealLights:setBrakeState(value, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setBrakeState("..tostring(value)..", "..tostring(noEventSend));
	--SetRealLight_BrakeEvent.sendEvent(self, value, noEventSend);	
	--self.rLights.bra.v = value;
	if self.isClient then
		for i,n in pairs(self.rLights.bra.nodes) do
			setShaderParameter(n, "offsetDir", value, 0, 0, 0, false);
		end;	
		if value > 0 then
			for i,n in pairs(self.rLights.bra.nodes) do
				setVisibility(n, true);
			end;	
		else 
			for i,n in pairs(self.rLights.bra.nodes) do
				setVisibility(n, false);
			end;	
		end; 	
	end;
end;


function RealLights:setBrakeIsPressed(value, noEventSend)
--print("["..tostring(self).."]".." function RealLights:setBrakeIsPressed("..tostring(value)..", "..tostring(noEventSend));
	SetRealLight_BrakeIsPressedEvent.sendEvent(self, value, noEventSend);
	self.isBrakePressed = value;	
end;