SteeringMode = {};

function SteeringMode.prerequisitesPresent(specializations)
    return true;
end;

function SteeringMode:load(xmlFile)
	
	self.setSteeringMode = SpecializationUtil.callSpecializationsFunction("setSteeringMode");
	
	self.isFourSteering = false;
	
	self.saveMinRpm = self.motor.minRpm;
	self.saveMaxRpm = self.motor.maxRpm[3];

	self.backupWheelRotMin = self.wheels[3].rotMin;
	self.backupWheelRotMax = self.wheels[3].rotMax;
	self.fuelUsedMultiplikator = 0.05;
	
end;

function SteeringMode:delete()
end;

function SteeringMode:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SteeringMode:keyEvent(unicode, sym, modifier, isDown)
end;

function SteeringMode:readStream(streamId, connection)
	local isFourSteering = streamReadBool(streamId);
	self:setSteeringMode(isFourSteering, true);
end;

function SteeringMode:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isFourSteering);
end;

function SteeringMode:update(dt)

	if self:getIsActive() and self.isClient then
		if self:getIsActiveForInput(false) then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				if self.isFourSteering then
					self:setSteeringMode(false);
				else
					self:setSteeringMode(true);
				end;
			end;
		end;
	end;
	
	if self:getIsActive() then
		local fuelUsed = self.fuelUsedMultiplikator*self.fuelUsage;
		self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
		g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
		g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
	
		if self.cylinderedHydraulicSoundEnabled then
			self.motor.minRpm = math.max(self.motor.minRpm-(dt*2), -400);
			self.fuelUsedMultiplikator = 0.75;
		else
			self.motor.minRpm = math.min(self.motor.minRpm+(dt*5), self.saveMinRpm);
			self.fuelUsedMultiplikator = 0.05;
		end;		
	else
		self.fuelUsedMultiplikator = 0;
	end;
	
end;

function SteeringMode:updateTick(dt)
		
	if self.isFourSteering then
		self.motor.maxRpm[3] = math.max(self.motor.maxRpm[3]-dt, self.saveMaxRpm/7);
		self.wheels[3].rotMin = math.max(self.wheels[3].rotMin-0.035, self.backupWheelRotMin);
		self.wheels[3].rotMax = math.min(self.wheels[3].rotMax+0.035, self.backupWheelRotMax);
		self.wheels[4].rotMin = math.max(self.wheels[4].rotMin-0.035, self.backupWheelRotMin);
		self.wheels[4].rotMax = math.min(self.wheels[4].rotMax+0.035, self.backupWheelRotMax);
	else
		self.motor.maxRpm[3] = math.min(self.motor.maxRpm[3]+dt, self.saveMaxRpm);
		self.wheels[3].rotMin = math.min(self.wheels[3].rotMin+0.035, 0);
		self.wheels[3].rotMax = math.max(self.wheels[3].rotMax-0.035, 0);
		self.wheels[4].rotMin = math.min(self.wheels[4].rotMin+0.035, 0);
		self.wheels[4].rotMax = math.max(self.wheels[4].rotMax-0.035, 0);
	end;

end;

function SteeringMode:draw()
	if self:getAttachedTrailersFillLevelAndCapacity() == nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("SET_STEERINGMODE"), InputBinding.IMPLEMENT_EXTRA3);
	end;
end;

function SteeringMode:setSteeringMode(isFourSteering, noEventSend)
	SetSteeringEvent.sendEvent(self, isFourSteering, noEventSend);
	self.isFourSteering = isFourSteering;
end;