SetSteeringEvent = {};
SetSteeringEvent_mt = Class(SetSteeringEvent, Event);

InitEventClass(SetSteeringEvent, "SetSteeringEvent");

function SetSteeringEvent:emptyNew()
    local self = Event:new(SetSteeringEvent_mt);
    self.className="SetSteeringEvent";
    return self;
end;

function SetSteeringEvent:new(object, isFourSteering)
    local self = SetSteeringEvent:emptyNew()
    self.object = object;
	self.isFourSteering = isFourSteering;
    return self;
end;

function SetSteeringEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isFourSteering = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetSteeringEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isFourSteering);
end;

function SetSteeringEvent:run(connection)
	self.object:setSteeringMode(self.isFourSteering);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetSteeringEvent:new(self.object, self.isFourSteering), nil, connection, self.object);
    end;	
end;

function SetSteeringEvent.sendEvent(vehicle, isFourSteering, noEventSend)
	if isFourSteering ~= vehicle.isFourSteering then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetSteeringEvent:new(vehicle, isFourSteering), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetSteeringEvent:new(vehicle, isFourSteering));
			end;
		end;
	end;
end;

