--
-- BagmoorsFarm
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BagmoorsFarm = {}

local BagmoorsFarm_mt = Class(BagmoorsFarm, Mission00);


function BagmoorsFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BagmoorsFarm_mt;
    end;
    local self = BagmoorsFarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function BagmoorsFarm:delete()
    BagmoorsFarm:superClass().delete(self);
end;

function BagmoorsFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function BagmoorsFarm:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("BagmoorsFarm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -26.1, 888.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -76.5, 869.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -107.4, 840.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);


    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -491, 420.4, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 756.7, 132.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -399.9, 404.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -523.8, 350.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -428.5, 415, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    BagmoorsFarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function BagmoorsFarm:onStartMission()
    BagmoorsFarm:superClass().onStartMission(self);
end;

function BagmoorsFarm:mouseEvent(posX, posY, isDown, isUp, button)
    BagmoorsFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BagmoorsFarm:keyEvent(unicode, sym, modifier, isDown)
    BagmoorsFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BagmoorsFarm:update(dt)
    BagmoorsFarm:superClass().update(self, dt);
end;

function BagmoorsFarm:draw()
    BagmoorsFarm:superClass().draw(self);
end;