--
-- BizonPickup specialization
-- @author		Burner
-- @date		31.03.2012
--

BizonPickup = {};

function BizonPickup.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function BizonPickup:load(xmlFile)
	self.setPickup = SpecializationUtil.callSpecializationsFunction("setPickup");
	--self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, BizonPickup.getIsAreaActive);
	self.objectInRange = BizonPickup.objectInRange;

	self.pickupActive = false;
	self.pickupNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickup#index"));
	
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"),0.5);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	if self.groundReferenceNode == nil then
		self.groundReferenceNode = self.components[1].node;
    end;
	
    self.cuttingAreasBackup = self.cuttingAreas;
	local numPickupAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pickupAreas#count"), 0);
    self.pickupAreas = {};
    for i=1, numPickupAreas do
        self.pickupAreas[i] = {};
        local areanamei = string.format("vehicle.pickupAreas.pickupArea%d", i);
        self.pickupAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.pickupAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.pickupAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.fruitTypesBackup = self.fruitTypes;
	self.pickupFruitTypes = {};
	self.pickupFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local pickupFruitTypes = getXMLString(xmlFile, "vehicle.pickupFruitTypes#fruitTypes");
	if pickupFruitTypes ~= nil then
		local types = Utils.splitString(" ", pickupFruitTypes);
		for k,v in pairs(types) do
			local desc = FruitUtil.fruitTypes[v];
			if desc ~= nil then
				self.pickupFruitTypes[desc.index] = true;
			end;
		end;
	end;

	self.pickupShowObjects = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.pickupShowObjects.pickupShowObject(%d)", i);
		local index = getXMLString(xmlFile, key.."#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			self.pickupShowObjects[i] = node;
			setVisibility(node, false);
		end;
		i = i +1;
	end;
	
	self.pickupHideObjects = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.pickupHideObjects.pickupHideObject(%d)", i);
		local index = getXMLString(xmlFile, key.."#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			self.pickupHideObjects[i] = node;
			setVisibility(node, true);
		end;
		i = i +1;
	end;
	
	self.threshingParticleSystemsBackup = self.threshingParticleSystems;
	self.pickupParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.pickupParticleSystems.pickupParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.pickupParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.pickupParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.pickupParticleSystems,false);
		i = i +1;		
    end;
end;

function BizonPickup:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'pickup="'.. tostring(self.pickupActive) ..'"';
	return attributes, nil;
end;

function BizonPickup:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local pickup = Utils.getNoNil(getXMLBool(xmlFile, key.."#pickup"), false);
		if pickup == true then
			self:setPickup(pickup);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function BizonPickup:delete()
end;

function BizonPickup:readStream(streamId, connection)
	self:setPickup(streamReadBool(streamId), true);
end;

function BizonPickup:writeStream(streamId, connection)
	streamWriteBool(streamId, self.pickupActive);
end;

function BizonPickup:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BizonPickup:keyEvent(unicode, sym, modifier, isDown)
end;

function BizonPickup:update(dt)
	if self:objectInRange(self.pickupNode) then
		if self.reelStarted == false then
			if InputBinding.hasEvent(InputBinding.BizonPickup_MountPickup) then
				self:setPickup(not self.pickupActive);
			end;
			if self.pickupActive then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonPickup_UnountPickup")), InputBinding.BizonPickup_MountPickup);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonPickup_MountPickup")), InputBinding.BizonPickup_MountPickup);
			end;
		end;
	end;
	if self.pickupActive and self.currentExtraObject ~= nil then
		setVisibility(self.currentExtraObject, false);
	end;
end;

function BizonPickup:updateTick(dt)
	if self.pickupActive then
		self.lastArea = 0;
		if self.reelStarted and self.movingDirection < 0 then
			--[[
			local hasGroundContact = false;
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if terrainHeight+self.groundReferenceThreshold >= y then
				hasGroundContact = true;
			end;
			]]
			--if hasGroundContact then
				local realArea = 0;
				for k,area in pairs(self.pickupAreas) do
					for fruitType,v in pairs(self.fruitTypes) do
						local x,y,z = getWorldTranslation(area.start);
						local x1,y1,z1 = getWorldTranslation(area.width);
						local x2,y2,z2 = getWorldTranslation(area.height);
						
						local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
						area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
						if area > 0 then
							self.currentFruitType = fruitType;
							self.lastArea = self.lastArea + area;
							realArea = realArea + area/g_currentMission.maxFruitValue;
						end;
					end;
					self.lastArea = self.lastArea * 5;
				end;
				local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
				local qm = realArea*pixelToQm;
				local ha = qm/10000;
				
				g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
				g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

				g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
				g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
			--end;
		end;
		self.lastAreaBiggerZero = (self.lastArea > 0);
	end;
end;

function BizonPickup:draw()
end;

function BizonPickup:onDetach()
end;

function BizonPickup:onLeave()
end;

function BizonPickup:onDeactivate()
end;

function BizonPickup:setPickup(pickupActive,noEventSend)
	SetPickupStateEvent.sendEvent(self, pickupActive, noEventSend);
	self.pickupActive = pickupActive;
	if self.pickupActive == false then
		self.threshingParticleSystems = self.threshingParticleSystemsBackup;
		Cutter.updateExtraObjects(self);
		self.cuttingAreas = self.cuttingAreasBackup;
		self.fruitTypes = self.fruitTypesBackup;
	else
		self.threshingParticleSystems = self.pickupParticleSystems;
		self.cuttingAreas = {};
		self.fruitTypes = self.pickupFruitTypes;
	end;
	for k, object in pairs(self.pickupHideObjects) do
		setVisibility(object, not self.pickupActive);
	end;
	for k, object in pairs(self.pickupShowObjects) do
		setVisibility(object, self.pickupActive);
	end;
end;

--[[
function BizonPickup:getIsAreaActive(superFunc, area)
	isLowered = self:isLowered(false);
	if isLowered == false then
		self.lastAreaBiggerZero = false;
	end;
	if superFunc ~= nil then
		return superFunc(self, area) and isLowered;
	end;
	return isLowered;
end;
]]

function BizonPickup:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 3;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;