--
-- GrainTankAnimation
-- Specialization for GrainTankAnimation
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

GrainTankAnimation = {};

function GrainTankAnimation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function GrainTankAnimation:load(xmlFile)
	
	self.setGraintankActive = SpecializationUtil.callSpecializationsFunction("setGraintankActive");	
	self.isGraintankExpanded = false;
	self.graintankWarning = 0;
	self.lastThreshingState = false;
	self.doFastMovement = false;
end;

function GrainTankAnimation:delete()
end;

function GrainTankAnimation:readStream(streamId, connection)
	self.doFastMovement = true;
	self:setGraintankActive(streamReadBool(streamId), true);
end;

function GrainTankAnimation:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isGraintankExpanded);
end;

function GrainTankAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GrainTankAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function GrainTankAnimation:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.SWITCH_GRAINTANK_STATE) then
			self:setGraintankActive(not self.isGraintankExpanded);
		end;
	end;
end;

function GrainTankAnimation:updateTick(dt)
	if self:getIsActive() then
		if self.grainTankFillLevel >11800 and not self.isGraintankExpanded then
			self:setGraintankActive(true, true);
		end;
	end;
end;

function GrainTankAnimation:draw()	
	if self.isGraintankExpanded then
		g_currentMission:addHelpButtonText(g_i18n:getText("CLOSE_GRAINTANK"), InputBinding.SWITCH_GRAINTANK_STATE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("OPEN_GRAINTANK"), InputBinding.SWITCH_GRAINTANK_STATE);
	end;
	
	if self.graintankWarning > self.time then
		g_currentMission:addWarning(g_i18n:getText("COULD_NOT_UNFOLD_GRAINTANK"), 0.018, 0.033);
	end;
end;

function GrainTankAnimation:onEnter()
	if not self.isGraintankExpanded then
		local animTimeLadder = nil;
		if self:getIsAnimationPlaying("openLadder") then			
			animTimeLadder = self:getAnimationTime("openLadder");
		end;
		self:playAnimation("openLadder", 1, animTimeLadder, true);	
	end;	
end;

function GrainTankAnimation:onLeave()
	if not self:getIsHired() then
		local animTimeLadder = nil;
		if self:getIsAnimationPlaying("openLadder") then			
			animTimeLadder = self:getAnimationTime("openLadder");
		end;
		self:playAnimation("openLadder", -1, animTimeLadder, true);	
	end;	
end;

function GrainTankAnimation:setIsThreshing(isThreshing, noEventSend)
	if isThreshing and not self.isGraintankExpanded then
		self:setGraintankActive(true, true);
	end;
end;

function GrainTankAnimation:setGraintankActive(isExpanded, noEventSend)	
	SetGraintankEvent.sendEvent(self, isExpanded, noEventSend);
	
	local animTimeTank = nil;
	local animTimeLadder = nil;
	if self:getIsAnimationPlaying("openGraintank") then			
		animTimeTank = self:getAnimationTime("openGraintank");
	end;
	if self:getIsAnimationPlaying("openLadder") then			
		animTimeLadder = self:getAnimationTime("openLadder");
	end;
	
	local multiplier = 1;
	if self.doFastMovement then
		multiplier = 100;
		self.doFastMovement = false;
	end;
	
	if self.grainTankFillLevel < 11800 or isExpanded then
		if isExpanded then
			self:playAnimation("openGraintank", 1*multiplier, animTimeTank, true);
			self:playAnimation("openLadder", -1*multiplier, animTimeLadder, true);	
		else
			self:playAnimation("openGraintank", -1*multiplier, animTimeTank, true);
			self:playAnimation("openLadder", 1*multiplier, animTimeLadder, true);
		end;
		self.isGraintankExpanded = isExpanded;
	else
		self.graintankWarning = self.time + 2000;
	end;
end;

function GrainTankAnimation:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isGraintankExpanded="' .. tostring(self.isGraintankExpanded) ..'"';
	return attributes, nil;
end;

function GrainTankAnimation:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isGraintankExpanded = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isGraintankExpanded"), false);
		self.doFastMovement = true;
		self:setGraintankActive(isGraintankExpanded or self.grainTankFillLevel > 11800, true)
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;