--
-- manureParticleFix
-- Specialization for Trailer allowing the particle to be displayed when unloading manure
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		01/12/2011
--

manureParticleFix = {}

function manureParticleFix.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function manureParticleFix:load(xmlFile)
	local i = 0;
	while true do
		local key = string.format("vehicle.dischargeParticleSystems.dischargeParticleSystem(%d)", i);
		local fruit = getXMLString(xmlFile, key .. "#type");
		local file = getXMLString(xmlFile, key .. "#file");
		if fruit == nil then
			break;
		end;
		if fruit == "manure" then			
			 local Particle = {};
			 local particleNode = Utils.loadParticleSystem(xmlFile, Particle, key, self.components, false, file, self.baseDirectory);
			 self.dischargeParticleSystems[Fillable.FILLTYPE_MANURE] = Particle;
		end;
		i = i + 1;
	end;
end;

function manureParticleFix:delete()
end;

function manureParticleFix:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manureParticleFix:keyEvent(unicode, sym, modifier, isDown)
end;

function manureParticleFix:readStream(streamId, connection)
end;

function manureParticleFix:writeStream(streamId, connection)
end;

function manureParticleFix:readUpdateStream(streamId, timestamp, connection)
end;

function manureParticleFix:writeUpdateStream(streamId, connection, dirtyMask)
end;

function manureParticleFix:update(dt)
end;

function manureParticleFix:updateTick(dt)
end;

function manureParticleFix:draw()
end;

function manureParticleFix:setAddedParts(currentPart, noEventSend)
end;
