WorkMF2190Event = {};
WorkMF2190Event_mt = Class(WorkMF2190Event, Event);

InitEventClass(WorkMF2190Event, "WorkMF2190Event");

function WorkMF2190Event:emptyNew()
    local self = Event:new(WorkMF2190Event_mt);
    self.className="WorkMF2190Event";
    return self;
end;

function WorkMF2190Event:new(vehicle, mode)
    local self = WorkMF2190Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function WorkMF2190Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function WorkMF2190Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function WorkMF2190Event:run(connection)   
	self.vehicle:WorkMF2190(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WorkMF2190Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function WorkMF2190Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WorkMF2190Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(WorkMF2190Event:new(vehicle, mode));
		end;
	end;
end;