UnloadMF2190Event = {};
UnloadMF2190Event_mt = Class(UnloadMF2190Event, Event);

InitEventClass(UnloadMF2190Event, "UnloadMF2190Event");

function UnloadMF2190Event:emptyNew()
    local self = Event:new(UnloadMF2190Event_mt);
    self.className="UnloadMF2190Event";
    return self;
end;

function UnloadMF2190Event:new(vehicle, mode)
    local self = UnloadMF2190Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function UnloadMF2190Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function UnloadMF2190Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function UnloadMF2190Event:run(connection)
	self.vehicle:UnloadMF2190(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(UnloadMF2190Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function UnloadMF2190Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(UnloadMF2190Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(UnloadMF2190Event:new(vehicle, mode));
		end;
	end;
end;