EmptyMF2190Event = {};
EmptyMF2190Event_mt = Class(EmptyMF2190Event, Event);

InitEventClass(EmptyMF2190Event, "EmptyMF2190Event");

function EmptyMF2190Event:emptyNew()
    local self = Event:new(EmptyMF2190Event_mt);
    self.className="EmptyMF2190Event";
    return self;
end;

function EmptyMF2190Event:new(vehicle, mode)
    local self = EmptyMF2190Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function EmptyMF2190Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function EmptyMF2190Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function EmptyMF2190Event:run(connection)
	self.vehicle:EmptyMF2190(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(EmptyMF2190Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function EmptyMF2190Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(EmptyMF2190Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(EmptyMF2190Event:new(vehicle, mode));
		end;
	end;
end;