BLightMF2190Event = {};
BLightMF2190Event_mt = Class(BLightMF2190Event, Event);

InitEventClass(BLightMF2190Event, "BLightMF2190Event");

function BLightMF2190Event:emptyNew()
    local self = Event:new(BLightMF2190Event_mt);
    self.className="BLightMF2190Event";
    return self;
end;

function BLightMF2190Event:new(vehicle, mode)
    local self = BLightMF2190Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function BLightMF2190Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BLightMF2190Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function BLightMF2190Event:run(connection)
	self.vehicle:BLightMF2190(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BLightMF2190Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function BLightMF2190Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BLightMF2190Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BLightMF2190Event:new(vehicle, mode));
		end;
	end;
end;