VariableTipEvent = {};
VariableTipEvent_mt = Class(VariableTipEvent, Event);

InitEventClass(VariableTipEvent, "VariableTipEvent");

function VariableTipEvent:emptyNew()
    local self = Event:new(VariableTipEvent_mt);
    self.className="VariableTipEvent";
    return self;
end;

function VariableTipEvent:new(vehicle, state)
    local self = VariableTipEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function VariableTipEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function VariableTipEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
end;

function VariableTipEvent:run(connection)
	--print("VariableTipEvent:run(connection)...");
	--if self.vehicle ~= nil then
		--print("self.state="..self.state.." self.vehicle="..tostring(self.vehicle));
	
		self.vehicle:setTipSide(self.state, true);
		if not connection:getIsServer() then
			g_server:broadcastEvent(VariableTipEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
		end;
	--end;
end;

function VariableTipEvent.sendEvent(vehicle, state, noEventSend)
	--print("VariableTipEvent.sendEvent(vehicle, state, noEventSend)");
	if vehicle == nil then
		print("--------> VariableTipEvent erRoR :/ ");
	end;
    if state ~= vehicle.varTip.activeTipIdx then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(VariableTipEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(VariableTipEvent:new(vehicle, state));
            end;
        end;
	end;
end;

