TurboBust = {};

function TurboBust.prerequisitesPresent(specializations)
    return true;
end;

function TurboBust:load(xmlFile)

    local turboStartSound = getXMLString(xmlFile, "vehicle.turboStartSound#file");
    if turboStartSound ~= nil and turboStartSound ~= "" then
        turboStartSound = Utils.getFilename(turboStartSound, self.baseDirectory); 
        self.turboStartSound = createSample("turboStartSound");
        loadSample(self.turboStartSound, turboStartSound, false);
        self.turboStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboStartSound#pitchOffset"), 1);
        self.turboStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboStartSound#volumen"), 1);
    end;
	
    local turboSound = getXMLString(xmlFile, "vehicle.turboSound#file");
    if turboSound ~= nil and turboSound ~= "" then
        turboSound = Utils.getFilename(turboSound, self.baseDirectory); 
        self.turboSound = createSample("turboSound");
        loadSample(self.turboSound, turboSound, false);
        self.turboSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboSound#pitchOffset"), 1);
        self.turboSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboSound#volumen"), 1);
    end;
	
    local turboStopSound = getXMLString(xmlFile, "vehicle.turboStopSound#file");
    if turboStopSound ~= nil and turboStopSound ~= "" then
        turboStopSound = Utils.getFilename(turboStopSound, self.baseDirectory); 
        self.turboStopSound = createSample("turboStopSound");
        loadSample(self.turboStopSound, turboStopSound, false);
        self.turboStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboStopSound#pitchOffset"), 1);
        self.turboStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboStopSound#volumen"), 1);
    end;
	
	self.TurboOn = false;
	self.TurboStart = true;
	self.TurboRunStart = false;
	self.TurboStartEnd = 0;
end;

function TurboBust:delete()
    if self.turboStartSound ~= nil then
        delete(self.turboStartSound);
    end;
    if self.turboSound ~= nil then
        delete(self.turboSound);
    end;
    if self.turboStopSound ~= nil then
        delete(self.turboStopSound);
    end;
end;

function TurboBust:mouseEvent(posX, posY, isDown, isUp, button)

end;

function TurboBust:keyEvent(unicode, sym, modifier, isDown)

end;

function TurboBust:update(dt)

	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.FendRedBull936_Turbo) then
			self.TurboOn = not self.TurboOn;
		end;
	else
		self.TurboOn = false;		
	end;
	
	if self:getIsActiveForSound() then
		if self.TurboStart and self.TurboOn then
			self.TurboStart = false;
			local turboSoundOffset = 0;
			if self.turboStartSound ~= nil then
				setSamplePitch(self.turboStartSound, self.turboStartSoundPitchOffset);
				playSample(self.turboStartSound, 1, self.turboStartSoundVolume, 0);
				turboSoundOffset = getSampleDuration(self.turboStartSound);
			end;
            self.TurboRunStart = true;
			self.TurboStartEnd = self.time+turboSoundOffset;			
		end;	
		if self.TurboRunStart and self.time >= self.TurboStartEnd and self.TurboOn then
			self.TurboRunStart = false 
			stopSample(self.turboStartSound);
			if self.turboSound ~= nil then
				setSamplePitch(self.turboSound, self.turboSoundPitchOffset);
				playSample(self.turboSound, 0, self.turboSoundVolume, 0);
			end;			
		end;	
	end;
	if not self.TurboOn and not self.TurboStart then
		stopSample(self.turboStartSound);
		stopSample(self.turboSound);
		self.TurboStart = true;
		self.TurboRunStart = false;
		self.TurboStartEnd = 0;
		if self.turboStopSound ~= nil then
			setSamplePitch(self.turboStopSound, self.turboStopSoundPitchOffset);
			playSample(self.turboStopSound, 1, self.turboStopSoundVolume, 0);
		end;
	end;
end;

function TurboBust:draw()
end;

function TurboBust:onLeave()
	stopSample(self.turboStartSound);
	stopSample(self.turboSound);
	stopSample(self.turboStopSound);
	self.TurboOn = false;
end;


