--
-- Washable
-- Specialization for Washable functionality
--
-- Modschmiede / LS-Modsource
-- @author  Manuel Leithner
-- @date  25/12/09
--

Washable = {};

function Washable.prerequisitesPresent(specializations)
    return true;
end;

function Washable:load(xmlFile)

	self.increaseDirt = SpecializationUtil.callSpecializationsFunction("increaseDirt");
	self.decreaseDirt = SpecializationUtil.callSpecializationsFunction("decreaseDirt");
	self.unusualDirtIncrease = SpecializationUtil.callSpecializationsFunction("unusualDirtIncrease");
	
	local count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dirt#count"), 0);
	self.dirtComponents = {};
	if count ~= 0 then
		for i=1, count do
			local componentName = string.format("vehicle.dirt.dirtComponent%d", i);	
			self.dirtComponents[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, componentName .. "#index"));	
		end;	
	end;	
	
	self.dirtInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dirt#dirtInterval"), 1) * 60 * 60 * 1000;
	self.cleaningInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dirt#cleaningInterval"), 30) * 1000;

	self.dirtScale = 0;
	self.oldDirtScale = self.dirtScale;
	self.timeScale = 1;

end;

function Washable:delete()
end;

function Washable:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Washable:keyEvent(unicode, sym, modifier, isDown)
end;

function Washable:update(dt)

	if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
		self:decreaseDirt(dt);
	else
		if self:getIsActive() or self.isActive then
			self:increaseDirt(dt);
		end;
	end;	
	
	if math.abs(self.dirtScale-self.oldDirtScale) > 0.001 then
		for i=1, table.getn(self.dirtComponents) do
			setShaderParameter(self.dirtComponents[i], "dirtScale", self.dirtScale, 0,0,0,false);
		end;
		self.oldDirtScale = self.dirtScale;
	end;
end;

function Washable:draw()
end;


function Washable:unusualDirtIncrease(increase)
	if self.dirtScale < 1 then
		self.dirtScale = self.dirtScale + increase;
		if self.dirtScale > 1 then
			self.dirtScale = 1;
		end;
	end;
end;

function Washable:increaseDirt(dt)
	if self.dirtScale > 1 then
		self.dirtScale = 1;
	end;
	if self.dirtScale < 1 then
		local scale = Utils.getMovedLimitedValues({self.dirtScale}, {1}, {0}, 1, self.dirtInterval*self.timeScale, dt, false);
		self.dirtScale = scale[1];
	end;
end;

function Washable:decreaseDirt(dt)
	if self.dirtScale < 0 then
		self.dirtScale = 0;
	end;
	if self.dirtScale > 0 then
		local scale = Utils.getMovedLimitedValues({self.dirtScale}, {1}, {0}, 1, self.cleaningInterval*self.timeScale, dt, true);
		self.dirtScale = scale[1];
	end;
end;

function Washable:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.dirtScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#dirtLevel"),0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Washable:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'dirtLevel="'.. tostring(self.dirtScale) .. '"';
    return attributes, nil;
end;