--
-- Ardbawn
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Ardbawn = {}

local Ardbawn_mt = Class(Ardbawn, Mission00);


function Ardbawn:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Ardbawn_mt;
    end;
    local self = Ardbawn:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function Ardbawn:delete()
    Ardbawn:superClass().delete(self);
end;

function Ardbawn:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function Ardbawn:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Ardbawn.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 - 130, 1024 - 383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 43.5, 1024 - 128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 395.1, 1024 - 693.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 888.8 , 1024 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    Ardbawn:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function Ardbawn:onStartMission()
    Ardbawn:superClass().onStartMission(self);
end;

function Ardbawn:mouseEvent(posX, posY, isDown, isUp, button)
    Ardbawn:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Ardbawn:keyEvent(unicode, sym, modifier, isDown)
    Ardbawn:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Ardbawn:update(dt)
    Ardbawn:superClass().update(self, dt);
end;

function Ardbawn:draw()
    Ardbawn:superClass().draw(self);
end;