
-- MOD: AnimalHUD --																																																		
--	MOD Version: 2.2 --																																																				
-- MOD Author: DjiZoN And ZiDan --																																													
-- MOD date: 31.01.2013 --																																																
-- Thanks Edmund (inspector) inspiration --																																												
-- Copyright (C) DjiZoN --																																														
-- Contact via PM @ jasongagne@live.ca --																																															


AnimalHUD = {};
AnimalHUD.moddir=g_currentModDirectory;
AnimalHUD.modName = g_currentModName;


function AnimalHUD:loadMap(name)
	self.AnimalHUDactive=true;
	self.Overlay ={};
	self.Overlay.OverlayId = {};
	self.Overlay.Width = 0.179;
	self.Overlay.Height = 0.30;
	self.Overlay.PosX = 0.813;
	self.Overlay.PosY = 0.58;
	self.Overlay.OverlayId.ovid = createImageOverlay(Utils.getFilename("OverlayAnimalHUDChicken.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidS = createImageOverlay(Utils.getFilename("OverlayAnimalHUDChickenAndSheep.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidC = createImageOverlay(Utils.getFilename("OverlayAnimalHUDChickenAndCow.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidAll = createImageOverlay(Utils.getFilename("OverlayAnimalHUDAll.dds", AnimalHUD.moddir));
	self.SubStringLength = 10;
end;


function AnimalHUD:deleteMap()
end;

function AnimalHUD:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimalHUD:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimalHUD:draw()
	local PosX = 0.818;
	local PosY = 0.835;
	local ValPosX =0.93;
	local ValPosY = 0.835;
	local nLine = 1;
	local fFontSize = 0.015;
	local fLineDist = fFontSize + 0.0019;
	setTextAlignment(RenderText.ALIGN_LEFT);
	local Animals = g_currentMission.husbandries;
	local PalletNil = false
	-- Overlay --
	if self.AnimalHUDactive then
		if self.Overlay.OverlayId.ovid ~= nil and self.Overlay.OverlayId.ovid ~= 0 then
			if Animals.chicken.totalNumAnimals >= 1 and Animals.sheep.totalNumAnimals <= 0 and Animals.cow.totalNumAnimals <= 0 then
				renderOverlay(self.Overlay.OverlayId.ovid, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals >= 1 and Animals.cow.totalNumAnimals <= 0 then
				renderOverlay(self.Overlay.OverlayId.ovidS, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals <= 0 and Animals.cow.totalNumAnimals >= 1 then
				renderOverlay(self.Overlay.OverlayId.ovidC, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals >= 1 and Animals.cow.totalNumAnimals >= 1 then
				renderOverlay(self.Overlay.OverlayId.ovidAll, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			end;
				
			-- Chicken --
			if Animals.chicken.totalNumAnimals > 0 then
				setTextColor(0.71,0.80,0.71,1);
				local lChickenOutput = "";
				local cChickenTotalNum = string.format("%1.0f", Animals.chicken.totalNumAnimals);
				lChickenOutput = g_i18n:getText("subCategory_chicken") .. ": " .. lChickenOutput;
				renderText(ValPosX, ValPosY, fFontSize, cChickenTotalNum) -- Valeur --
				renderText(PosX, PosY, fFontSize, lChickenOutput); -- subCategory_chicken --
				local i = 0.012;
				-- Egg Carriying --
				local lEggCarrying = "";
				local mission = g_currentMission;
				local cChickenEggCarrying = string.format("%1.0f", mission:getSiloAmount(Fillable.FILLTYPE_EGG));
				lEggCarrying = g_i18n:getText("Eggs_carrying") .. ": " .. lEggCarrying;
				renderText(ValPosX, ValPosY - (i), fFontSize, cChickenEggCarrying); -- Valeur --
				renderText(PosX, PosY - (i), fFontSize, lEggCarrying); -- Eggs_carrying --
				local i = i + 0.012;
				-- Egg Enclo --
				local lEggOutput = "";
				local cChickenEgg = string.format("%1.0f", Animals.chicken.numActivePickupObjects);
				local EggWarning = 50;
				if Animals.chicken.numActivePickupObjects >= EggWarning then
					setTextColor(1,0,0,1);
				end;
				lEggOutput = g_i18n:getText("egg") .. ": " .. lEggOutput;
				renderText(ValPosX, ValPosY - (i), fFontSize, cChickenEgg); -- Valeur -- 
				renderText(PosX, PosY - (i), fFontSize, lEggOutput) -- egg --
			end;	
			
			-- Sheep --
			
			if Animals.sheep.totalNumAnimals > 0 then
				setTextColor(0.71,0.80,0.71,1);
				local sPosY = PosY - 0.044;
				local sValPosY = ValPosY - 0.044;
				local lSheepOutput = "";
				local cSheepTotalNum = string.format("%1.0f", Animals.sheep.totalNumAnimals);
				lSheepOutput = g_i18n:getText("subCategory_sheep") .. ": " .. lSheepOutput;
				renderText(ValPosX, sValPosY, fFontSize, cSheepTotalNum); -- Valeur --
				renderText(PosX, sPosY, fFontSize, lSheepOutput) -- subCategory_sheep --
				local i = 0.012;
				-- Sheep Auge -- 
				local lSheepAugeOutput = "";
				local cSheepAuge = Animals.sheep:getFluidStatsText(Animals.sheep:getFillLevel(Fillable.FILLTYPE_FORAGE)).. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lSheepAugeOutput = g_i18n:getText("FeedingTroughMisc_storage") .. ": " .. lSheepAugeOutput;
				renderText(ValPosX, sValPosY - i , fFontSize, cSheepAuge); -- Valeur --
				renderText(PosX, sPosY - i , fFontSize, lSheepAugeOutput);	-- Auge --
				local i = i + 0.012;
				-- Sheep Productivity --
				local lSheepProductivityOutput = "";
				local cSheepProductivity = string.format("%1.0f", Animals.sheep.productivity * 100).. "% ";
				lSheepProductivityOutput = g_i18n:getText("Productivity") .. ": " .. lSheepProductivityOutput;
				renderText(ValPosX, sValPosY - (i), fFontSize, cSheepProductivity); -- Valeur --
				renderText(PosX, sPosY - (i), fFontSize, lSheepProductivityOutput); -- Productivity --

				local i = i + 0.012;
				-- Sheep Wool Pallet --
				local lSheepWoolOutput = "";
				local cSheepWoolNil = "0% ";
				lSheepWoolOutput = g_i18n:getText("wool") .. ": " .. lSheepWoolOutput;	
				if Animals.sheep.currentPallet == nil then
					PalletNil = true
					renderText(ValPosX, sValPosY - (i), fFontSize, cSheepWoolNil);-- Valeur Nil --
					renderText(PosX, sPosY - (i), fFontSize, lSheepWoolOutput);-- Wool --
				end;
				if PalletNil == false then
					local cSheepWool = string.format("%1.0f", Animals.sheep.currentPallet.fillLevel / Animals.sheep.currentPallet.capacity * 100) .. "% ";
					renderText(ValPosX, sValPosY - (i), fFontSize, cSheepWool); -- Valeur pallet present --
					renderText(PosX, sPosY - (i), fFontSize, lSheepWoolOutput); -- Wool --
				end;
			end;	
			
			-- Cows --
			local cPosY = PosY - 0.044;
			local cValPosY = ValPosY - 0.044;
			if Animals.sheep.totalNumAnimals >= 1 then
				cPosY = PosY - 0.1;
				cValPosY = ValPosY - 0.1;
			end;
			if Animals.cow.totalNumAnimals > 0 then
				setTextColor(0.71,0.80,0.71,1);
				local lCowOutput = "";
				local cCowTotalNum = string.format("%1.0f", Animals.cow.totalNumAnimals);
				lCowOutput = g_i18n:getText("subCategory_cow") .. ": " .. lCowOutput;
				renderText(ValPosX, cValPosY, fFontSize, cCowTotalNum); -- Valeur --
				renderText(PosX, cPosY, fFontSize, lCowOutput); -- Cows --
				-- Cow Productivity --
				local i = 0.012;
				local lCowProductivityOutput = "";
				local cCowProductivity = round(Animals.cow.productivity * 100) .. "% ";
				lCowProductivityOutput = g_i18n:getText("Productivity") .. ": " .. lCowProductivityOutput;
				renderText(ValPosX, cValPosY - i, fFontSize, cCowProductivity); -- Valeur --
				renderText(PosX, cPosY - i, fFontSize, lCowProductivityOutput); --  Productivity --
				-- Cow Auge (Melange) --
				setTextColor(0.71,0.80,0.71,1);
				local i = i + 0.012;
				local lCowAugeOutput = "";
				local lCowAugeEngOutput = "";
				local cCowAugeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_FORAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowAugeOutput = g_i18n:getText("FeedingTroughForage_storage") .. ": " .. lCowAugeOutput;
				lCowAugeEngOutput = "Feeding trough (Mixed):"
					if g_i18n:getText("FeedingTroughForage_storage") == "Feeding trough (Mixed ration)" then
						renderText(PosX, cPosY - (i), fFontSize, lCowAugeEngOutput);
						renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeLevel);
					else
						renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeLevel); -- Valeur --
						renderText(PosX, cPosY - (i), fFontSize, lCowAugeOutput); -- Auge (Melange) --
					end;
				-- Cow Auge (Fourrage Enssil) --
				local i = i + 0.012;
				local lCowAugeEnsileOutput = "";
				local cCowAugeEnsileLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_SILAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowAugeEnsileOutput = g_i18n:getText("FeedingTroughSilage_storage") .. ": " .. lCowAugeEnsileOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeEnsileLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowAugeEnsileOutput); --  (Fourrage Enssil) --
				-- Cow Auge (Herbe) --
				local i = i + 0.012;
				local lCowAugeHerbeOutput = "";
				local cCowAugeHerbeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowAugeHerbeOutput = g_i18n:getText("FeedingTroughGrass_storage") .. ":" .. lCowAugeHerbeOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeHerbeLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowAugeHerbeOutput); -- Auge (Herbe) --
				-- Cow Paille --
				local i = i + 0.012;
				local lCowPailleOutput = "";
				local cCowPailleLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_WHEAT_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowPailleOutput = g_i18n:getText("Straw_storage") .. ":" ..lCowPailleOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowPailleLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowPailleOutput); --  Paille --
				-- Cow Engrais Liquide --
				local i = i + 0.012;
				local lCowEngraisLiquideOutput = "";
				local cCowEngraisLiquideLevel = Animals.cow:getFluidStatsText(Animals.cow.liquidManureTrigger.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowEngraisLiquideOutput = g_i18n:getText("LiquidManure_storage") .. ": " ..  lCowEngraisLiquideOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowEngraisLiquideLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowEngraisLiquideOutput); --  Engrais Liquide --
				-- Cow Engrais Solide --
				local i = i + 0.012;
				local lCowEngraisSolideOutput = "";
				local cCowEngraisSolideLevel = Animals.cow:getFluidStatsText(Animals.cow.manureHeap.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowEngraisSolideOutput = g_i18n:getText("Manure_storage") .. ": " ..  lCowEngraisSolideOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowEngraisSolideLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowEngraisSolideOutput); --  Engrais Solide --
				-- Cow Milk --
				local i = i + 0.012;
				local lCowMilkOutput = "";
				local cCowMilkLevel = Animals.cow:getFluidStatsText(Animals.cow.fillLevelMilk) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowMilkOutput = g_i18n:getText("Milk_storage") .. ":" .. lCowMilkOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowMilkLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowMilkOutput); --  Milk --
			end;	
		else
            self.AnimalHUDactive = false;
		end;
	end;
end;

function round(num, idp)
	if Utils.getNoNil(num, 0) > 0 then
		local mult = 10^(idp or 0);
		return math.floor(num * mult + 0.5) / mult;
	else 
		return 0;
	end;
end; 

function AnimalHUD:update(dt)
	if InputBinding.hasEvent(InputBinding.Animal_TOGGLE) then
		if self.Overlay.OverlayId.ovid ~= nil and self.Overlay.OverlayId.ovid ~= 0 then
			self.AnimalHUDactive=not self.AnimalHUDactive;
		end;
	end;
end;

addModEventListener(AnimalHUD);