--------------------------------------------------------------------------------------
-- MOD: AnimalStatus
-- MOD Author: WLKe
-- Version 0.6 - 11.7.2013 - release for FS2013 
-- Copyright (C) WLKe -- wlke@wlke.net
--------------------------------------------------------------------------------------
print("AnimalStatus 0.6 by WLKe loaded");

AnimalStatus = {};

PosX = 0.813; 		-- base x position
PosY = 0.849;			-- base y position
fPosX = PosX;
fPosY = PosY - 0.005;
Line = 1;			 -- line counter
fVal = PosX + 0.155; -- Value x position
fVar = fVal + 0.0025;
fLine = 0.012;		-- line height
aShow = false;
aTrans = true;
fFontSize = 0.015;
fAlpha = 1;
fLastLine = 1;

function AnimalStatus:loadMap(name)
self.Warmup = true;
self.updateMs = 0;
self.updateMin = 0;
self.updateIntervall = 20;
self.locales = {}
self.locales.Water = g_i18n:getText("water")
self.locales.pcs = g_i18n:getText("pcs")
self.locales.warmup = g_i18n:getText("warmup")
self.locales.day = g_i18n:getText("day")
self.locales.day1 = g_i18n:getText("day1")
self.locales.day5 = g_i18n:getText("day5")
self.locales.pigs = g_i18n:getText("pigs")
self.locales.grain_fruits = g_i18n:getText("grain_fruits")

fWarn = {}
fWarn["chicken"] = {}
fWarn["sheep"] = {}
fWarn["cow"] = {}
fWarn["SchweineZucht"] = {}
fWarn["chicken"]["productivity"] = 40;
fWarn["chicken"]["egg"] = 40;
fWarn["sheep"]["productivity"] = 40;
fWarn["sheep"]["woolpercent"] = 90;
fWarn["cow"]["productivity"] = 40;
fWarn["cow"]["Manure_storage"] = 85;
fWarn["cow"]["LiquidManure_storage"] = 85;
fWarn["SchweineZucht"]["productivity"] = 40;
fWarn["SchweineZucht"]["Manure_storage"] = 85;
fWarn["SchweineZucht"]["LiquidManure_storage"] = 85;
fWarn["SchweineZucht"]["grain_fruits"] = 2;
fWarn["SchweineZucht"]["earth_fruits"] = 2;
fWarn["SchweineZucht"]["silage"] = 2;
fWarn["SchweineZucht"]["forage"] = 2;
fWarn["SchweineZucht"]["water"] = 2;
fWarn["SchweineZucht"]["wheat_windrow"] = 2;


fCowForageDay = 0;
fTransparent = true;
fGiants = false;

local FutterTypes = {[Fillable.FILLTYPE_FORAGE] = 4,
					 [Fillable.FILLTYPE_WATER] = 5,
					 [Fillable.FILLTYPE_BARLEY_WINDROW] = 6,
					 [Fillable.FILLTYPE_WHEAT_WINDROW] = 6};
end;

function AnimalStatus:deleteMap()
end;

function AnimalStatus:setcolor()
	if aTrans == true then
		setTextColor(1,1,1,fAlpha);
	else
		if aTrans == false then
			setTextColor(0,0,0,fAlpha);
		end;
	end;
end

function AnimalStatus:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimalStatus:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_multiply and bitAND(modifier, Input.MOD_ALT) > 0 then
		if aShow then 
			aShow = false;
		else
			aShow = true;
		end;
	end;
	if isDown and sym == Input.KEY_leftbracket and bitAND(modifier, Input.MOD_ALT) > 0 then
		if fTransparent then
			fTransparent = false;
			fGiants = true;
		else
			if fGiants then
				fTransparent = true;
				fGiants = false;
			end;
		end;	
	end;
end;

function AnimalStatus:update(dt)

	self.updateMs = self.updateMs + (dt * g_currentMission.missionStats.timeScale);
	if self.updateMs >= 60000 then
		self.updateMs = self.updateMs - 60000;
		self.updateMin = self.updateMin + 1;
		if self.updateMin > 20 then
			self.Warmup = false;
		end;
	end;
	fDifficulty = g_currentMission.missionInfo.difficulty;
	if math.ceil(g_currentMission.environment.dayTime) > 20*60*60*1000 or math.ceil(g_currentMission.environment.dayTime) < 6*60*60*1000 then
		self.day=false;
	else
		self.day=true;
	end;
end;

function AnimalStatus:get_locale(self, key)
  return self.locales[key]
end;

function AnimalStatus:Day(fFillDay)
	if fFillDay == 1 then 
		return g_i18n:getText("day1")
	elseif fFillDay > 1 and fFillDay < 5 then
		return g_i18n:getText("day")
	elseif fFillDay >= 5 or fFillDay < 1 then 
		return g_i18n:getText("day5")
	else 
		return g_i18n:getText("day")
	end;
end;

function AnimalStatus:warncolor(cAnim,cType,cVal,cState)
	if cAnim ~= nil and cType ~= nil and cVal ~= nil and cState ~= nil then
		if self.Warmup and cType == "productivity" then
			if aTrans then
				setTextColor(0.98,0.76,0.43,fAlpha);
			elseif not aTrans then
				setTextColor(0.38,0.16,0.03,fAlpha);
			end;
			return true;
		end;
		local global_start = 10;
		if cState == "over" and fWarn[cAnim][cType] <= cVal then
				setTextColor(1,0,0,fAlpha);
		elseif cState == "under" and fWarn[cAnim][cType] > cVal then
				setTextColor(1,0,0,fAlpha);
		else
			AnimalStatus:setcolor();
		end;
	end;
end;
function AnimalStatus:draw()
	if aShow then return true; end;
	Line = 1;
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
	if self.day then fAlpha = 1; else fAlpha = 0.8; end;
	AnimalStatus:AnimalShow("chicken");
	AnimalStatus:AnimalShow("sheep");
	AnimalStatus:AnimalShow("cow");
	AnimalStatus:AnimalShow("SchweineZucht");
	if Line > 1 then 
		if self.Overlay ~= nil then self.Overlay:delete();end;
		self.OverlayTransparent = Overlay:new("OverlayTransparent",getUserProfileAppPath() .. "mods/AnimalStatus/" .. "Transparent.dds", PosX - 0.005, PosY - Line*fFontSize, 1 - fPosX + .007 , (Line + 0.5)*fFontSize);
		self.OverlayGiants = 	  Overlay:new("OverlayGiants",getUserProfileAppPath() .. "mods/AnimalStatus/" .. "Giants.dds", PosX - 0.005, PosY - Line*fFontSize, 1 - fPosX + .007 , (Line + 0.5)*fFontSize);
		if fTransparent then 
			aTrans = true;
			self.OverlayGiants:delete();
			self.OverlayTransparent:render();
		elseif fGiants then
			aTrans = false;
			self.OverlayTransparent:delete();
			self.OverlayGiants:render();
		end;
	end;
	setTextColor(1,1,1,fAlpha);
end;
function AnimalStatus:PrintManure(param,fType,fValue,fPercent)
	if param ~= nil and fType ~= nil then 
		if fValue == nil then fValue = 0;end;
		if fPercent == nil then fPercent = 0;end;
		AnimalStatus:setcolor();
		setTextAlignment(RenderText.ALIGN_LEFT);
		AnimalStatus:warncolor(param,fType,fPercent,"over");
		renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText(fType)..":"));
		setTextAlignment(RenderText.ALIGN_RIGHT);
		renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%6d",fValue).."L   ");
		setTextAlignment(RenderText.ALIGN_LEFT);	
		renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%2d",fPercent).."%");
		Line = Line + 1;
	end;
end;

function AnimalStatus:GetDay(FillLevel,param,fFillType,nHus,fDifficulty)
	local fDay = 0;
	local fEat = {}
	fEat["chicken"] = {}
	fEat["sheep"] = {}
	fEat["cow"] = {}
	fEat["SchweineZucht"] = {}
	fEat["chicken"]["water"] = 1;
	fEat["chicken"]["wheat"] = 0.5;
	fEat["cow"]["forage"] = 190;
	fEat["cow"]["silage"] = 85;
	fEat["cow"]["wheat_windrow"] = 60;
	fEat["cow"]["grass_windrow"] = 115;	
	fEat["cow"]["water"] = 60;	
	fEat["sheep"]["water"] = 11;	
	fEat["sheep"]["forage"] = 12;
	fEat["SchweineZucht"]["earth_fruits"] = 24;
	fEat["SchweineZucht"]["grain_fruits"] = 24;
	fEat["SchweineZucht"]["forage"] = 87.3;
	fEat["SchweineZucht"]["silage"] = 87.3;
	fEat["SchweineZucht"]["water"] = 74.7;
	fEat["SchweineZucht"]["wheat_windrow"] = 74.7;
	if (param == "chicken" and nHus > 1) or (param ~= "chicken" and nHus > 0) then 
		if fEat[param][fFillType] ~= nil and nHus > 0 then
			if param == "SchweineZucht" and (fFillType == "sugarBeet" or fFillType == "potato") then fFillType = "earth_fruits"; end;
			if param == "SchweineZucht" and (fFillType == "wheat" or fFillType == "barley") then fFillType = "wheat_fruits"; end;
			if fDifficulty == 1 then
				fDay = math.abs(math.ceil(FillLevel/(fEat[param][fFillType] * nHus)));
				return fDay;
			elseif fDifficulty == 2 then
				fDay = math.abs(math.ceil(FillLevel/(fEat[param][fFillType] * nHus * 1.33)));
				return fDay;
			elseif fDifficulty == 3 then
				fDay = math.abs(math.ceil(FillLevel/(fEat[param][fFillType] * nHus * 1.66)));
				return fDay;
			end;
		end;
	else
		return 0;
	end;
end;


function AnimalStatus:TriggShow(param,nHus,test)
	local global_start = 10;

	for page = 1 ,table.getn(g_currentMission.missionPDA.statsPages) do
		local fParam = g_currentMission.missionPDA.statsPages[page].param
		if fParam and (fParam == param) and g_currentMission.missionPDA.statsPages[page].target.tipTriggersFillLevels ~= nil then
			for FillType,Triggers in pairs(g_currentMission.missionPDA.statsPages[page].target.tipTriggersFillLevels) do
				local FillLevel = 0;
				for j = 1 ,table.getn(Triggers) do
					local index = Triggers[j].tipTriggerIndex
					FillLevel = (FillLevel or 0) + Triggers[j].fillLevel
				end;
				if FillLevel ~= nil then
					if test == true then 
						if math.ceil(FillLevel) > 0 then 
							return true;
						end;
					end;
					if test ~= true then
						AnimalStatus:setcolor();
						fFillType = Fillable.fillTypeIntToName[FillType];
					
						if g_i18n:hasText(fFillType) then
							i18FillType = g_i18n:getText(fFillType);
						else 
							i18FillType = fFillType;	 
						end;
						local fFillDay = (AnimalStatus:GetDay(FillLevel,param,fFillType,nHus,fDifficulty));
						if fFillDay == "--" then fFillDay = 0;end;
						if param == "cow" and fFillType == "forage" then fCowForageDay = fFillDay; end;
						if (fFillDay <= 1 and fFillDay ~= nil) then 
							if param == "cow" and (fFillType ~= "wheat_windrow" and fFillType ~= "water") and fCowForageDay > 1 then 
								setTextColor(0.98,0.76,0.43,fAlpha);
							else 
								if (param == "chicken" and nHus > 1) or (param ~= "chicken" and nHus > 0) then
									setTextColor(1,0,0,fAlpha);
								else
									AnimalStatus:setcolor();
								end;
							end;
						end;
						setTextAlignment(RenderText.ALIGN_LEFT);
						renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",i18FillType..":"));
						setTextAlignment(RenderText.ALIGN_RIGHT);
						if fFillDay ~= nil and ((param == "chicken" and nHus > 1) or (param ~= "chicken" and nHus > 0)) then
							renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",FillLevel).."L "..string.format("%2d",fFillDay));
							setTextAlignment(RenderText.ALIGN_LEFT);
							renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fFillDay));
							Line = Line + 1;
						else
							renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",FillLevel));
							setTextAlignment(RenderText.ALIGN_LEFT);
							renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"L");
							Line = Line + 1;
						end
					end;
				end;
			end;
			if test == true then return false; end;
		end;
	end;
end;
function AnimalStatus:AnimalShow(param)
	if param == "chicken" and g_currentMission.husbandries.chicken ~= nil then
		local fChickenNum = g_currentMission.husbandries.chicken.totalNumAnimals;
		local fChickProd = math.ceil(g_currentMission.husbandries.chicken.productivity*100)
		local fEggsCarr = g_currentMission:getSiloAmount(Fillable.FILLTYPE_EGG);
		local fEggsNum = g_currentMission.husbandries.chicken.numActivePickupObjects;
		if fChickenNum > 1 or AnimalStatus:TriggShow("chicken",fChickenNum,true) == true then
			setTextAlignment(RenderText.ALIGN_LEFT);
			AnimalStatus:setcolor();
			setTextBold(true);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("subCategory_chicken")..":"));
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%4d",fChickenNum));	
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));
			Line = Line + 1;
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
			if fChickenNum > 1 then AnimalStatus:warncolor("chicken","productivity",fChickProd,"under");end;
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("Productivity")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			if self.Warmup ~= true then
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fChickProd));
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"%");
				Line = Line + 1;		
			else
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%s",g_i18n:getText("warmup")));
				setTextAlignment(RenderText.ALIGN_LEFT);
				Line = Line + 1;		
			end
			
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("Eggs_carrying")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%4d",fEggsCarr));	
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));			
			Line = Line + 1;
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
			if fChickenNum > 1 then AnimalStatus:warncolor("chicken","egg",fEggsNum,"over");end;
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("egg")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fEggsNum));	
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));			
			Line = Line + 1;
			AnimalStatus:TriggShow("chicken",fChickenNum,false);
			setTextAlignment(RenderText.ALIGN_LEFT);
			AnimalStatus:setcolor();
		end;
	end;
	if param == "sheep" and g_currentMission.husbandries.sheep ~= nil then
		local fSheepNum = g_currentMission.husbandries.sheep.totalNumAnimals;
		if fSheepNum > 0 or AnimalStatus:TriggShow("sheep",fSheepNum,true) == true then
			if Line > 1 then
				Line = Line - 0.5
				renderText(fPosX, fPosY - (Line*fLine) ,0.011,"----------------------------------------------------------------");
				Line = Line + 1;
			end;		
			local fWoolLevel = 0;
			local fWoolCapacity = 0;
			local fWoolPercent = 0;
			if g_currentMission.husbandries.sheep.currentPallet ~= nil then 
				fWoolLevel = math.abs(math.ceil(g_currentMission.husbandries.sheep.currentPallet.fillLevel-.5));
				fWoolCapacity = math.ceil(g_currentMission.husbandries.sheep.currentPallet.capacity);
				fWoolPercent = math.abs(math.ceil((fWoolLevel / fWoolCapacity -.005) *100));	
			else 
				fWoolLevel = 0;
				fWoolCapacity = 0;
				fWoolPercent = 0;
			end;
			local fSheepProd = math.ceil(g_currentMission.husbandries.sheep.productivity*100);		
			setTextAlignment(RenderText.ALIGN_LEFT);
			AnimalStatus:setcolor();
			setTextBold(true);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("subCategory_sheep")..":"));
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%4d",fSheepNum));	
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));
			Line = Line + 1;
			if fSheepNum > 0 then AnimalStatus:warncolor("sheep","productivity",fSheepProd,"under");end;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("Productivity")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			if self.Warmup ~= true then
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fSheepProd));
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"%");
				Line = Line + 1;		
			else
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%s",g_i18n:getText("warmup")));
				setTextAlignment(RenderText.ALIGN_LEFT);
				Line = Line + 1;		
			end			
			AnimalStatus:setcolor();
			if g_currentMission.husbandries.sheep.currentPallet ~= nil then
				if fSheepNum > 1 then AnimalStatus:warncolor("sheep","woolpercent",fWoolPercent,"over");end;
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("wool")..":"));
				setTextAlignment(RenderText.ALIGN_RIGHT);
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fWoolLevel).."L"..string.format("%3d",fWoolPercent));
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"%");
				Line = Line + 1;
				AnimalStatus:setcolor();
			end;
			AnimalStatus:TriggShow("sheep",fSheepNum,false);
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
		end;
	end;
	if param == "cow" and g_currentMission.husbandries.cow ~= nil then
		local fCowNum = g_currentMission.husbandries.cow.totalNumAnimals;
		local fCowProd = math.ceil(g_currentMission.husbandries.cow.productivity*100);
		local fCowMilkLevel = g_currentMission.husbandries.cow.fillLevelMilk;
		if fCowNum > 0 or AnimalStatus:TriggShow("cow",fCowNum,true) == true then
			if Line > 1 then
				Line = Line - 0.5
				renderText(fPosX, fPosY - (Line*fLine) ,0.011,"----------------------------------------------------------------");
				Line = Line + 1;
			end;		
			setTextAlignment(RenderText.ALIGN_LEFT);
			AnimalStatus:setcolor();
			setTextBold(true);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("subCategory_cow")..":"));
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%4d",fCowNum));	
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));
			Line = Line + 1;
			setTextAlignment(RenderText.ALIGN_LEFT);
			if fCowNum > 0 then AnimalStatus:warncolor("cow","productivity",fCowProd,"under");end;
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("Productivity")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			if self.Warmup ~= true then
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fCowProd));
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"%");
				Line = Line + 1;		
			else
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%s",g_i18n:getText("warmup")));
				setTextAlignment(RenderText.ALIGN_LEFT);
				Line = Line + 1;		
			end	
			AnimalStatus:setcolor();
			AnimalStatus:TriggShow("cow",fCowNum,false);
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s",g_i18n:getText("Milk_storage")..":"));
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",fCowMilkLevel).."L   ");
			Line = Line + 1;			
			if  g_currentMission.husbandries.cow.manureHeap ~= nil then
				local fCowManure = math.ceil(g_currentMission.husbandries.cow.manureHeap.fillLevel);
				local fCowManureCapacity = math.ceil(g_currentMission.husbandries.cow.manureHeap.capacity);
				local fCowManurePercent = math.abs(math.ceil((fCowManure / fCowManureCapacity -.005) *100));			
				if fCowManureCapacity > 0 then AnimalStatus:PrintManure(param,"Manure_storage",fCowManure,fCowManurePercent);end;
			else
				local fCowManure = -1;
				local fCowManureCapacity = -1;
				local fCowManurePercent = -1;
			end;
			if g_currentMission.husbandries.cow.liquidManureTrigger ~= nil then
				local fCowLiqManure = math.ceil(g_currentMission.husbandries.cow.liquidManureTrigger.fillLevel);
				local fCowLiqManureCapacity = math.ceil(g_currentMission.husbandries.cow.liquidManureTrigger.capacity);
				local fCowLiqManurePercent = math.abs(math.ceil((fCowLiqManure / fCowLiqManureCapacity -.005) *100));
				if fCowLiqManureCapacity > 0 then AnimalStatus:PrintManure(param,"LiquidManure_storage",fCowLiqManure,fCowLiqManurePercent);end;
			else
				local fCowLiqManure = -1;
				local fCowLiqManureCapacity = -1;
				local fCowLiqManurePercent = -1;			
			end;
			AnimalStatus:setcolor();
			setTextAlignment(RenderText.ALIGN_LEFT);
		end;
	end;
		if param == "SchweineZucht" then
		for page = 1 ,table.getn(g_currentMission.missionPDA.statsPages) do
			if g_currentMission.missionPDA.statsPages[page].target.numSchweine ~= nil then
				local fPigManure = g_currentMission.missionPDA.statsPages[page].target.manureHeap.FillLvl;
				local fPigManureCapacity = g_currentMission.missionPDA.statsPages[page].target.manureHeap.capacity;
				local fPigManurePercent = math.abs(math.ceil((fPigManure / fPigManureCapacity -.005) *100));
				local fPigLiqManure = g_currentMission.missionPDA.statsPages[page].target.liquidManureSiloTrigger.fillLevel;
				local fPigLiqManureCapacity = g_currentMission.missionPDA.statsPages[page].target.liquidManureSiloTrigger.capacity;
				local fPigLiqManurePercent = math.abs(math.ceil((fPigLiqManure / fPigLiqManureCapacity -.005) *100));
				local fPigProductivity = math.ceil(g_currentMission.missionPDA.statsPages[page].target.Produktivi*100);
				local fNumPigs=g_currentMission.missionPDA.statsPages[page].target.numSchweine
				if g_currentMission.missionPDA.statsPages[page].target.numSchweine > 0 or  fPigManurePercent > 0 or fPigLiqManurePercent > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[1] > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[2] > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[3] > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[4] > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[5] > 0 or g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[6] > 0 then
					if Line > 1 then
						Line = Line - 0.5
						renderText(fPosX, fPosY - (Line*fLine) ,0.011,"----------------------------------------------------------------");
						Line = Line + 1;
					end;					
					setTextBold(true);
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("pigs")..":"));	
					setTextBold(false);
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%4d",g_currentMission.missionPDA.statsPages[page].target.numSchweine));	
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,g_i18n:getText("pcs"));				
					Line = Line + 1;
				
					setTextAlignment(RenderText.ALIGN_LEFT);
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"productivity",fPigProductivity,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("Productivity")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					if self.Warmup ~= true then
						renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%3d",fPigProductivity));
						setTextAlignment(RenderText.ALIGN_LEFT);
						renderText(fVar, fPosY - (Line*fLine) ,fFontSize,"%");
						Line = Line + 1;		
					else
						setTextAlignment(RenderText.ALIGN_CENTER);
						renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%s",g_i18n:getText("warmup")));
						setTextAlignment(RenderText.ALIGN_LEFT);
						Line = Line + 1;		
					end						
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[1];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"grain_fruits",fNumPigs,fDifficulty);					
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"grain_fruits",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("grain_fruits")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[1]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));
					Line = Line + 1;
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[2];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"earth_fruits",fNumPigs,fDifficulty);					
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"earth_fruits",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("sugarBeet")..","..g_i18n:getText("potato")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[2]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));
					Line = Line + 1;
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[3];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"silage",fNumPigs,fDifficulty);						
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"silage",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_SILAGE].nameI18N..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[3]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));
					Line = Line + 1;				
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[4];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"forage",fNumPigs,fDifficulty);					
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"forage",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("forage")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[4]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));					
					Line = Line + 1;
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[5];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"water",fNumPigs,fDifficulty);					
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"water",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("water")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[5]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));					
					Line = Line + 1;
					
					AnimalStatus:setcolor();
					setTextAlignment(RenderText.ALIGN_LEFT);
					local fPigGrainFill=g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[6];
					local fDays=AnimalStatus:GetDay(fPigGrainFill,param,"wheat_windrow",fNumPigs,fDifficulty);					
					if fNumPigs > 0 then AnimalStatus:warncolor(param,"wheat_windrow",fDays,"under");end;
					renderText(fPosX, fPosY - (Line*fLine),fFontSize, string.format("%s", g_i18n:getText("wheat_windrow")..":"));
					setTextAlignment(RenderText.ALIGN_RIGHT);
					renderText(fVal, fPosY - (Line*fLine) ,fFontSize, string.format("%5d",g_currentMission.missionPDA.statsPages[page].target.FutterTypLvl[6]).."L "..string.format("%2d",fDays));
					setTextAlignment(RenderText.ALIGN_LEFT);
					renderText(fVar, fPosY - (Line*fLine) ,fFontSize,AnimalStatus:Day(fDays));		
					Line = Line + 1;		
					AnimalStatus:PrintManure(param,"Manure_storage",fPigManure,fPigManurePercent);			
					AnimalStatus:PrintManure(param,"LiquidManure_storage",fPigLiqManure,fPigLiqManurePercent);
					setTextAlignment(RenderText.ALIGN_LEFT);
				end;
			end;
		end;			
	end;
end;

addModEventListener(AnimalStatus);