--
-- manschette
-- Specialization for manschette
--
-- @author upsidedown
-- @date  13.07.2013


manschette = {};

function manschette.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function manschette:load(xmlFile)
		self.manschetteNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manschette#index1"));
		self.manschetteNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manschette#index2"));
		self.fillerArmInRange = false;
		self.manschetteWasMoved = false;
		self.manschetteDrawLine = false;
		
		local tx, ty, tz = getTranslation(self.manschetteNode1);
		self.manschetteYmax1 = ty;
		tx, ty, tz = getTranslation(self.manschetteNode2);
		self.manschetteYmax2 = ty;
end;

function manschette:update(dt)
		if self.manschetteDrawLine then
			local dx, dy, dz = localDirectionToWorld(self.rootNode, 0, 0, 1);
			local length = Utils.vector2Length(dx,dz);
			local dx = dx/length;
			local dz = dz/length;
			
			
			local ax,ay,az = getTranslation(self.manschetteNode1);
						
			local x_offset = 3.10; --in later version get this number from 'arm'-vehicle
			local x,y,z = localToWorld(self.manschetteNode1,ax+x_offset,ay,az);-- start point at the side of the vehicle
			
			local r = 0;
			local g = 0;
			local b = 1;
			local ploty = 0;
			local plotx = 0;
			local plotz = 0;
			
			for k = -15,25,2 do
				plotx = x + k*dx;
				plotz = z + k*dz;
				ploty = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, plotx, py, plotz) + .2;
				plotx2 = x + (k+1)*dx;
				plotz2 = z + (k+1)*dz;
				ploty2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, plotx2, py, plotz2) + .2;

				drawDebugLine(plotx, ploty, plotz, r, g, b, plotx2, ploty2, plotz2, r, g, b);				
			end;
			
			if self.fillerArm.vehicle:getIsActiveForInput(false) then --z distance calculation				
				local vx, vy, vz = getWorldTranslation(self.fillerArm.fillerArmNode);
				local fx, fy, fz = worldToLocal(self.manschetteNode1,vx,vy,vz);
				if math.abs(fz) < 0.01 then -- prevent +/- flickering
					fz = 0;
				end;
				
				--g_currentMission.fruitSymbolY g_currentMission.fruitSymbolSize
				setTextAlignment(RenderText.ALIGN_RIGHT); 

				setTextBold(true);
				setTextColor(math.min(.8*math.abs(fz/1.5),1),.8,0,1);
				renderText(.99,g_currentMission.fruitSymbolY + 0*g_currentMission.fruitSymbolSize + 0.03,0.022, string.format("%2.2f m", -fz));
				--renderText(.402+ 0.085,0.85238 + 0.010,0.022, string.format("proof of principle: Einweisung Befuellarm: %2.2f m", -fz));
				setTextAlignment(RenderText.ALIGN_LEFT); -- (hopefully) prevent influence on scripts without explicit format coding
				setTextBold(false);
				setTextColor(1,1,1,1);
			end
		end;
end;

function manschette:updateTick(dt)	
        self.fillerArmInRange = false; 
        local nearestDistance = 30;
        local px, py, pz = getWorldTranslation(self.manschetteNode1);
        for i=1, table.getn(g_currentMission.attachables) do
            if g_currentMission.attachables[i].fillerArmNode ~= nil then 
				local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].fillerArmNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					--self.fillerArmInRange = true;
					nearestDistance = distance;
					self.fillerArm = {};
					self.fillerArm.vehicle = g_currentMission.attachables[i];
					self.fillerArm.fillerArmNode = g_currentMission.attachables[i].fillerArmNode;
				end;
			end;
        end;
		
		if nearestDistance < .2 then			
			self.fillerArmInRange = true;
		end;
		
		if self.fillerArmInRange then --animation Manschette			
			local vx, vy, vz = getWorldTranslation(self.fillerArm.fillerArmNode);
			
			local x,y,z = worldToLocal(self.manschetteNode1,vx, vy, vz);
			local rx,ry,rz = getRotation(self.manschetteNode1);
			
			local maxRot = 0.6;
			rx = Utils.clamp(rx + 2.0*Utils.clamp(z,-.05,.05),-maxRot,maxRot);
			rz = Utils.clamp(rz - 2.0*Utils.clamp(x,-.05,.05),-maxRot,maxRot);
			setRotation(self.manschetteNode2,.3*rx,0,.3*rz);
			setRotation(self.manschetteNode1,rx,0,rz);
			
			local startPushing = 0.075;
			
				local maxTrans = .1;				
				local tx, ty, tz = getTranslation(self.manschetteNode1)
				local tx2, ty2, tz2 = getTranslation(self.manschetteNode2)
				
				local dty = (y-startPushing)*0.01*dt
				
				ty = Utils.clamp(ty+dty,self.manschetteYmax1-maxTrans,self.manschetteYmax1);
				ty2 = Utils.clamp(ty2+1.5*dty,self.manschetteYmax2-maxTrans,self.manschetteYmax2);
				
				
				setTranslation(self.manschetteNode1,tx, ty, tz)
				setTranslation(self.manschetteNode2,tx2, ty2, tz2)
				
			--print(ty)
			self.manschetteWasMoved	= true;
		elseif self.manschetteWasMoved then --return to neutral position
			local resetFactor = 1-dt*0.002;
			local rx,ry,rz = getRotation(self.manschetteNode1);
			rx = resetFactor * rx;
			rz = resetFactor * rz;
			local rotDone = false;
			
			if math.abs(rx) < .001 and math.abs(rz) < 0.001 then
				rx = 0;
				rz = 0;
				rotDone = true;
			end;
			setRotation(self.manschetteNode2,.3*rx,0,.3*rz);
			setRotation(self.manschetteNode1,rx,0,rz);
			
			
			local tx, ty, tz = getTranslation(self.manschetteNode1)
			local dty = 0.003*dt*(self.manschetteYmax1 - ty);
			setTranslation(self.manschetteNode1,tx, ty+dty, tz)
			
			tx, ty, tz = getTranslation(self.manschetteNode2)
			dty = 0.003*dt*(self.manschetteYmax2 - ty);
			setTranslation(self.manschetteNode2,tx, ty+dty, tz)
			--
			
			if rotDone and math.abs(self.manschetteYmax2 - ty) < 0.01 then
				self.manschetteWasMoved = false;
			end;
			
		end;
		
		if nearestDistance < 25 then
			self.manschetteDrawLine = true;
		else
			self.manschetteDrawLine = false;
		end
		
		
end;

--function manschette:fertilizerInRange(dt)
--end;

function manschette:delete()
end;

function manschette:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manschette:keyEvent(unicode, sym, modifier, isDown)
end;

function manschette:draw()
end;

function manschette:onAttach()
end; 	

function manschette:onDetach()
end;