--
-- hoseConnect
-- Specialization for hoseConnect
--
-- @author upsidedown
-- @date  01.08.2013


hoseConnect = {};

function hoseConnect.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function hoseConnect:load(xmlFile)
	

	self.hoseConnectTargetNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoseConnect#targetNode"));
	self.hoseConnectEndNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoseConnect#endNode"));
	self.hoseConnectCenterNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoseConnect#centerNode"));
	
	self.hoseConnectVisPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoseConnect#visPart"));
	
	self.hoseConnectBoneNodes = {}
	self.hoseConnectBoneNodes[1] = self.hoseConnectEndNode;
	self.hoseConnectorAllowConnect = false;
	self.hoseConnectorConnect = false;
	self.hoseConnectorConnectFlag = true;
	self.hoseConnectorOverload = false;
	self.hoseConnectorOverloadPossible = false;
	
	-- local x, y = getScreenModeInfo(getScreenMode())
		-- local aspectRatio = x / y
	-- local hudFactor = 0.95;
	
	-- local path = Utils.getFilename("FB_Befuellung_moeglich.dds", self.baseDirectory);
		-- self.hoseConnectorReadyOverlay = Overlay:new("hudReady", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize*hudFactor, g_currentMission.fruitSymbolSize * aspectRatio*hudFactor); 
		-- path = Utils.getFilename("FB_Befuellung_laeuft.dds", self.baseDirectory);
		-- self.hoseConnectorActiveOverlay = Overlay:new("hudActive", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize*hudFactor, g_currentMission.fruitSymbolSize * aspectRatio*hudFactor); 
		-- path = Utils.getFilename("FB_Kontakt.dds", self.baseDirectory);
		-- self.hoseConnectorContact = Overlay:new("hudActive2", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize*hudFactor, g_currentMission.fruitSymbolSize * aspectRatio*hudFactor); 
		-- path = Utils.getFilename("FB_Befuellkreislauf.dds", self.baseDirectory);
		-- self.hoseConnectorActiveBlinkOverlay = Overlay:new("hudActive3", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize*hudFactor, g_currentMission.fruitSymbolSize * aspectRatio*hudFactor); 
		

	-- self.hoseConnectorReadyOverlay
	-- self.hoseConnectorActiveOverlay
	-- self.hoseConnectorContact
	-- self.hoseConnectorActiveBlinkOverlay
	
	
	
	--test verschieben
	-- local x,y,z = getTranslation(self.hoseConnectTargetNode)
	-- setTranslation(self.hoseConnectTargetNode,x,y+1.5,z);
end;

function hoseConnect:update(dt)

--self.hoseConnectorActiveOverlay:render()
	
	--renderOverlay(self.hoseConnectorActiveOverlay.overlayId, self.hoseConnectorActiveOverlay.x, self.hoseConnectorActiveOverlay.y, self.hoseConnectorActiveOverlay.width, self.hoseConnectorActiveOverlay.height)
	
	if self.hoseConnector ~= nil then
		--if self.hoseConnector.vehicle.hoseConnectorPlayerInRange then
		if self.hoseConnector.vehicle:getIsActiveForInput(false) then
			-- if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				-- self.hoseConnector.vehicle:toggle(1,not self.hoseConnector.vehicle.animParts[1].toMax);
			-- end			
			-- g_currentMission:addHelpButtonText("Drehen", InputBinding.IMPLEMENT_EXTRA3);
		
			if self.hoseConnectorAllowConnect then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self.hoseConnectorConnect = not self.hoseConnectorConnect;
					self.hoseConnectorConnectFlag = true;
					
					if g_server ~= nil then
						g_server:broadcastEvent(hoseConnect_Event:new(self, self.hoseConnectorConnect), nil, nil, self);
					else
						g_client:getServerConnection():sendEvent(hoseConnect_Event:new(self, self.hoseConnectorConnect));
					end;	
					
					
				end;
				g_currentMission:addHelpButtonText(g_i18n:getText("hoseAttach"), InputBinding.IMPLEMENT_EXTRA2);
				
			end
			
		end;
		
		if self.hoseConnectorConnect then
			if self.hoseConnectorOverloadPossible then
				--if self.hoseConnector.vehicle.hoseConnectorPlayerInRange or self.hoseConnector.vehicle:getIsActiveForInput(false) then
				if self.hoseConnector.vehicle:getIsActiveForInput(false) then
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
						self.hoseConnectorOverload = not self.hoseConnectorOverload;
						if g_server ~= nil then
							g_server:broadcastEvent(hoseConnectOverload_Event:new(self, self.hoseConnectorOverload), nil, nil, self);
						else
							g_client:getServerConnection():sendEvent(hoseConnectOverload_Event:new(self, self.hoseConnectorOverload));
						end;	
						
					end
					g_currentMission:addHelpButtonText(g_i18n:getText("hoseOverload"), InputBinding.IMPLEMENT_EXTRA3);
					
					
				end;
			else
				self.hoseConnectorOverload = false;
			end;			
		else
			self.hoseConnectorOverload = false;
		end;
		
		if self.hoseConnectorAllowConnect then
			self.hoseConnector.vehicle.hoseConnectorHUDTimeOut = 500;
			if self.hoseConnectorConnect then
				if self.hoseConnectorOverloadPossible then
					if self.hoseConnectorOverload then
						self.hoseConnector.vehicle.hoseConnectorHUDselect = 4;
					else
						self.hoseConnector.vehicle.hoseConnectorHUDselect = 2;
					end;
				else
					self.hoseConnector.vehicle.hoseConnectorHUDselect = 3;
				end;					
			else -- in range for hose
				self.hoseConnector.vehicle.hoseConnectorHUDselect = 1;
			end;
		end;
	
	end;
	
	
end;

function hoseConnect:updateTick(dt)
	
	self.hoseConnectorInRange = false; 
	local nearestDistance = 30;
	local px, py, pz = getWorldTranslation(self.hoseConnectCenterNode);
	for i=1, table.getn(g_currentMission.attachables) do
		if g_currentMission.attachables[i].hoseConnectorTargetNode ~= nil then 
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].hoseConnectorTargetNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				nearestDistance = distance;
				self.hoseConnector = {};
				self.hoseConnector.vehicle = g_currentMission.attachables[i];
				self.hoseConnector.hoseConnectorTargetNode = g_currentMission.attachables[i].hoseConnectorTargetNode;
			end;
		end;
	end;
	
	if nearestDistance < 2 then			
		self.hoseConnectorInRange = true;
	end;
	
	self.hoseConnectorAllowConnect = false;
	self.hoseConnectorOverloadPossible = false;
	if self.hoseConnectorInRange then 
		if self.hoseConnector.vehicle.hoseConnectorReady then
			--check incoming angle..
			local rx,ry,rz = localDirectionToWorld(self.hoseConnector.vehicle.rootNode, 0, 0, 1)
			local x,y,z = worldDirectionToLocal(self.hoseConnectCenterNode,rx,ry,rz)
			local angle = math.deg(Utils.getYRotationFromDirection(x, z))
			
			if math.abs(angle) < 30 then		
				self.hoseConnectorAllowConnect = true;
			end;
		end;
		----------------
		local motorOK = false;
		if self.hoseConnector.vehicle.attacherVehicle ~= nil then
			if self.hoseConnector.vehicle.attacherVehicle.motor~=nil then -- we have a motor
				if self.hoseConnector.vehicle.attacherVehicle.isMotorStarted  then
					motorOK = true;
				end;
			else -- dolly?
				if self.hoseConnector.vehicle.attacherVehicle.attacherVehicle ~= nil then --looks like dolly
					if self.hoseConnector.vehicle.attacherVehicle.attacherVehicle.motor ~= nil then
						if self.hoseConnector.vehicle.attacherVehicle.attacherVehicle.isMotorStarted  then
							motorOK = true;
						end;
					end
				end
			end
		end
		-----------------
		
		
		self.hoseConnectorOverloadPossible = motorOK and self.fillLevel > 0 and self.hoseConnector.vehicle.capacity ~= self.hoseConnector.vehicle.fillLevel;
	end;
	
	if self.hoseConnectorConnect and not self.hoseConnectorAllowConnect then --abort connection!
		self.hoseConnectorConnect = false;
		self.hoseConnectorConnectFlag = true;	
	end

	if self.hoseConnectorConnectFlag then
		if self.hoseConnectorConnect then
			link(self.hoseConnector.hoseConnectorTargetNode,self.hoseConnectBoneNodes[1])
			setVisibility(self.hoseConnectVisPart,true);
		else
			link(self.hoseConnectTargetNode,self.hoseConnectBoneNodes[1])
			setVisibility(self.hoseConnectVisPart,false);
		end;
		self.hoseConnectorConnectFlag = false;
	end;
	
	
	
	local delta = 0;
		if self.hoseConnectorOverload then
			if self.hoseConnector.vehicle.capacity ~= self.hoseConnector.vehicle.fillLevel then
				if self.fillLevel > 0 then
					
					delta = self.hoseConnector.vehicle.fillLitersPerSecond*dt/1000;
					if self.fillLevel < delta then
						delta = self.fillLevel;
					end
					if self.hoseConnector.vehicle.fillLevel + delta > self.hoseConnector.vehicle.capacity then
						delta = self.hoseConnector.vehicle.capacity - self.hoseConnector.vehicle.fillLevel
					end
									
				end
			end			
		end
		
		if delta > 0 then
			self.hoseConnector.vehicle:setFillLevel(self.hoseConnector.vehicle.fillLevel + delta,self.currentFillType)
			self:setFillLevel(self.fillLevel - delta,self.currentFillType)
		else		    
			self.hoseConnectorOverload = false;
		end
	
	
	
end;

function hoseConnect:delete()
end;

function hoseConnect:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hoseConnect:keyEvent(unicode, sym, modifier, isDown)
end;

function hoseConnect:draw()
	-- 
	-- self.hoseConnectorActiveOverlay:render()
end;

function hoseConnect:onAttach()
end; 	

function hoseConnect:onDetach()
end;


function hoseConnect:writeStream(streamId, connection)
    streamWriteBool(streamId, self.hoseConnectorConnect);
	streamWriteBool(streamId, self.hoseConnectorOverload);

end;


function hoseConnect:readStream(streamId, connection)
    self.hoseConnectorConnect = streamReadBool(streamId);
    self.hoseConnectorConnectFlag = true;
	self.hoseConnectorOverload = streamReadBool(streamId);
end;



hoseConnect_Event = {};
  hoseConnect_Event_mt = Class(hoseConnect_Event, Event);
  
  InitEventClass(hoseConnect_Event, "hoseConnect_Event");
  
  function hoseConnect_Event:emptyNew()
      local self = Event:new(hoseConnect_Event_mt);
      return self;
  end;
  
  function hoseConnect_Event:new(object, data)
      local self = hoseConnect_Event:emptyNew()
      self.data = data;
	  
      self.object = object;
      return self;
  end;
  
  function hoseConnect_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.data = streamReadBool(streamId);
      
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function hoseConnect_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.data);

  end;
  
  function hoseConnect_Event:run(connection)
	  self.object.hoseConnectorConnect = self.data;
	  self.object.hoseConnectorConnectFlag = true;
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(hoseConnect_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;
  
  
  
  
  hoseConnectOverload_Event = {};
  hoseConnectOverload_Event_mt = Class(hoseConnectOverload_Event, Event);
  
  InitEventClass(hoseConnectOverload_Event, "hoseConnectOverload_Event");
  
  function hoseConnectOverload_Event:emptyNew()
      local self = Event:new(hoseConnectOverload_Event_mt);
      return self;
  end;
  
  function hoseConnectOverload_Event:new(object, data)
      local self = hoseConnectOverload_Event:emptyNew()
      self.data = data;
	  
      self.object = object;
      return self;
  end;
  
  function hoseConnectOverload_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.data = streamReadBool(streamId);
      
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function hoseConnectOverload_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.data);

  end;
  
  function hoseConnectOverload_Event:run(connection)
	  self.object.hoseConnectorOverload = self.data;
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(hoseConnectOverload_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;