--
-- autoLMload
-- Specialization for autoLMload
--
-- @author upsidedown
-- @date  01.08.2013


autoLMload = {};

function autoLMload.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function autoLMload:load(xmlFile)
	self.autoLMloadHose1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.autoLMload#hoseIndex1"));
	self.autoLMloadHose2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.autoLMload#hoseIndex2"));
	
	self.visTarget = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.autoLMload#visTargetIndex"));
	
	self.autoLMloadFixTimer = 0;
	self.autoLMloadMoveMass = 0.9;--getMass(self.rootNode);
	--print(self.autoLMloadMoveMass)
	--print("load")
end;

function autoLMload:update(dt)
	
end;

function autoLMload:updateTick(dt)
	local active = false;
	if self.attacherVehicle == nil then
		if table.getn(self.sprayerFillTriggers) > 0 then
			active = true;
		end;
		if self.autoLMloadFixTimer < 2500 then
			self.autoLMloadFixTimer = self.autoLMloadFixTimer + dt;
		end;
		if self.autoLMloadFixTimer > 2450 then
			setMass(self.rootNode,55555555555555)
		
			
		end;
	else --transport mode;
		setMass(self.rootNode,self.autoLMloadMoveMass)
		
	end;
	
	if self.isServer then
		self:setIsSprayerFilling(active, true)
	end;
	setVisibility(self.autoLMloadHose1,active)
	setVisibility(self.autoLMloadHose2,active)
	setVisibility(self.visTarget,active);
	
	local x,y,z = getWorldTranslation(self.visTarget);
	local y0 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z) + 0;
	Utils.setWorldTranslation(self.visTarget,x,y0,z)
end;

function autoLMload:delete()
end;

function autoLMload:mouseEvent(posX, posY, isDown, isUp, button)
end;

function autoLMload:keyEvent(unicode, sym, modifier, isDown)
end;

function autoLMload:draw()
	if not active then
		if table.getn(self.sprayerFillTriggers) > 0 then
			g_currentMission:addExtraPrintText(g_i18n:getText("hosePlaceHere"));
			--g_i18n:getText("hosePlaceHere")
		end
	end;
end;

function autoLMload:onAttach()
end; 	

function autoLMload:onDetach()
end;