--
-- AmmergauerAlpen
-- by Nubsi  All Rights Reserved
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

AmmergauerAlpen = {}

local AmmergauerAlpen_mt = Class(AmmergauerAlpen, Mission00);


function AmmergauerAlpen:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = AmmergauerAlpen_mt;
    end;
    local self = AmmergauerAlpen:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function AmmergauerAlpen:delete()
    AmmergauerAlpen:superClass().delete(self);
end;

function AmmergauerAlpen:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/AmmergauerAlpen.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function AmmergauerAlpen:loadMap01Finished(node, arguments)

    self.terrainDetailAngleNumChannels = 4;
    self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("AmmergauerAlpen.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;
    
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 425,-369, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 598,203, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 750, -460, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 120, -90	, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -64, -645, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -10, -144, iconSize, iconSize * (4 / 3), false, false, false, 0, true);



    AmmergauerAlpen:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function AmmergauerAlpen:onStartMission()
    AmmergauerAlpen:superClass().onStartMission(self);
end;

function AmmergauerAlpen:mouseEvent(posX, posY, isDown, isUp, button)
    AmmergauerAlpen:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function AmmergauerAlpen:keyEvent(unicode, sym, modifier, isDown)
    AmmergauerAlpen:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function AmmergauerAlpen:update(dt)
    AmmergauerAlpen:superClass().update(self, dt);
end;

function AmmergauerAlpen:draw()
    AmmergauerAlpen:superClass().draw(self);
end;