--
-- Autor: Siwus
-- Specialization for sprayer
--


precyzyjna_dawka = {};

function precyzyjna_dawka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations) ;
	end;


function precyzyjna_dawka:load(xmlFile)
	self.skladanie = SpecializationUtil.callSpecializationsFunction("skladanie");

	self.szerokosc = 40;
	self.literPerHa = 200;
	self.lewastrona	= true;
	self.prawastrona = true;
	self.chemia = false;
	self.wymieszanie = 100;
	self.ciecz = self.fillLevel;
	
	--Oproznianie opryskiwacza
	self.oproznianie = false;
	self.zbiornik = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Zbiornik#index"));
	setVisibility(self.zbiornik, false);

	
	--Wlaczanie poszczegolnych sekcji belki polowej
	self.lewa = 4;
	self.prawa = 4;
	self.znak1 = 1;
	self.znak2 = 1;
	
	--HUD
	self.info = false;
	self.hud = Overlay:new("hud", Utils.getFilename("HUD/hud.dds", self.baseDirectory),0.6295, 0.236, 0.36, 0.66);
	self.ux_hud = Overlay:new("aloe_hud", Utils.getFilename("HUD/ux_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux1_True_hud = Overlay:new("ux1_True_hud", Utils.getFilename("HUD/ux1_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux2_True_hud = Overlay:new("ux2_True_hud", Utils.getFilename("HUD/ux2_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux3_True_hud = Overlay:new("ux3_True_hud", Utils.getFilename("HUD/ux3_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux4_True_hud = Overlay:new("ux4_True_hud", Utils.getFilename("HUD/ux4_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux5_True_hud = Overlay:new("ux5_True_hud", Utils.getFilename("HUD/ux5_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux6_True_hud = Overlay:new("ux6_True_hud", Utils.getFilename("HUD/ux6_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux7_True_hud = Overlay:new("ux7_True_hud", Utils.getFilename("HUD/ux7_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	self.ux8_True_hud = Overlay:new("ux8_True_hud", Utils.getFilename("HUD/ux8_True_hud.dds", self.baseDirectory), 0.405, 0.01238, 0.2371, 0.039525);
	--Wlaczanie poszczegolnych sekcji belki polowej	
	
	
	--Wylaczanie PS
		--1
	local translationPart1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart1#index"));
    if translationPart1Node ~= nil then
        self.translationPart1 = {};
        self.translationPart1.node = translationPart1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#minTrans"));
        self.translationPart1.minTrans = {};
        self.translationPart1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#maxTrans"));
        self.translationPart1.maxTrans = {};
        self.translationPart1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#transTime"), 2)*1000;
        self.translationPart1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#touchTransLimit"), 10);
    end;
	self.translationMax1 =  false;
		--2
	local translationPart2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPart2Node ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPart2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
	self.translationMax2 =  false;	
		--3
	local translationPart3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPart3Node ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPart3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
	self.translationMax3 =  false;
		--4
	local translationPart4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart4#index"));
    if translationPart4Node ~= nil then
        self.translationPart4 = {};
        self.translationPart4.node = translationPart4Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#minTrans"));
        self.translationPart4.minTrans = {};
        self.translationPart4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#maxTrans"));
        self.translationPart4.maxTrans = {};
        self.translationPart4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#transTime"), 2)*1000;
        self.translationPart4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#touchTransLimit"), 10);
    end;
	self.translationMax4 =  false;
		--5
	local translationPart5Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart5#index"));
    if translationPart5Node ~= nil then
        self.translationPart5 = {};
        self.translationPart5.node = translationPart5Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#minTrans"));
        self.translationPart5.minTrans = {};
        self.translationPart5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#maxTrans"));
        self.translationPart5.maxTrans = {};
        self.translationPart5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#transTime"), 2)*1000;
        self.translationPart5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#touchTransLimit"), 10);
    end;
	self.translationMax5 =  false;
		--6
	local translationPart6Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart6#index"));
    if translationPart6Node ~= nil then
        self.translationPart6 = {};
        self.translationPart6.node = translationPart6Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart6#minTrans"));
        self.translationPart6.minTrans = {};
        self.translationPart6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart6#maxTrans"));
        self.translationPart6.maxTrans = {};
        self.translationPart6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart6#transTime"), 2)*1000;
        self.translationPart6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart6#touchTransLimit"), 10);
    end;
	self.translationMax6 =  false;
			--7
	local translationPart7Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart7#index"));
    if translationPart7Node ~= nil then
        self.translationPart7 = {};
        self.translationPart7.node = translationPart7Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart7#minTrans"));
        self.translationPart7.minTrans = {};
        self.translationPart7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart7#maxTrans"));
        self.translationPart7.maxTrans = {};
        self.translationPart7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart7.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart7#transTime"), 2)*1000;
        self.translationPart7.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart7#touchTransLimit"), 10);
    end;
	self.translationMax7 =  false;
		--8
	local translationPart8Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart8#index"));
    if translationPart8Node ~= nil then
        self.translationPart8 = {};
        self.translationPart8.node = translationPart8Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart8#minTrans"));
        self.translationPart8.minTrans = {};
        self.translationPart8.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart8.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart8.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart8#maxTrans"));
        self.translationPart8.maxTrans = {};
        self.translationPart8.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart8.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart8.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart8.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart8#transTime"), 2)*1000;
        self.translationPart8.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart8#touchTransLimit"), 10);
    end;
	self.translationMax8 =  false;
	--Wylaczanie PS
		
	
	--Wylaczanie poszczegolnych obszarow
	local numCuttingAreasBow = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreasBow#count"), 0);
	self.cuttingAreasBow = {};
    for i=1, numCuttingAreasBow do
        self.cuttingAreasBow[i] = {};
        local areanamei = string.format("vehicle.cuttingAreasBow.cuttingArea%d", i);
        self.cuttingAreasBow[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasBow[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasBow[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	--Wylaczanie poszczegolnych obszarow
	
		
	--Skladanie jednej strony belki polowej
	self.lewabelkaAnimationName = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lewabelkaAnimation#name"), "");
	if self.playAnimation == nil or self.getIsAnimationPlaying == nil then
    self.lewabelkaAnimationName = "";
    end;
    self.lewabelkaAnimationLowerSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.lewabelkaAnimation#lowerSpeed"), 1);
	self.lewabelkaAnimationLiftSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.lewabelkaAnimation#liftSpeed"), -self.lewabelkaAnimationLowerSpeed);
	
	self.prawabelkaAnimationName = Utils.getNoNil(getXMLString(xmlFile, "vehicle.prawabelkaAnimation#name"), "");
	if self.playAnimation == nil or self.getIsAnimationPlaying == nil then
    self.prawabelkaAnimationName = "";
    end;
    self.prawabelkaAnimationLowerSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.prawabelkaAnimation#lowerSpeed"), 1);
	self.prawabelkaAnimationLiftSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.prawabelkaAnimation#liftSpeed"), -self.prawabelkaAnimationLowerSpeed);
	--Skladanie jednej strony belki polowej
	
	
	--Mieszanie chemikaliow
	self.chemiaAnimationName = Utils.getNoNil(getXMLString(xmlFile, "vehicle.chemiaAnimation#name"), "");
	if self.playAnimation == nil or self.getIsAnimationPlaying == nil then
    self.chemiaAnimationName = "";
    end;
    self.chemiaAnimationLowerSpeed = 1;
	self.chemiaAnimationLiftSpeed = -1;
	--Mieszanie chemikaliow
end;


function precyzyjna_dawka:update(dt)
	if self.attacherVehicle then
	
	if self.oproznianie and not self.chemia and self.fillLevel > 0.1 then
		self.fillLevel = self.fillLevel - 0.5;
		setVisibility(self.zbiornik, true);
	else
		setVisibility(self.zbiornik, false);
	end;
	
	-- if self.chemia and self.ciecz < self.fillLevel then
		-- self.ciecz = self.ciecz + 0.5;
	-- elseif not self.chemia then
		-- self.ciecz = 0; 
		-- self.wymieszanie = 0;
	-- end;
	-- self.wymieszanie = (self.ciecz/self.fillLevel) * 100;	
	
	if self.lewa < 0 then
		self.lewa = 4;
	elseif self.lewa > 4 then
		self.lewa = 0;
	end;
	
	if self.prawa < 0 then
		self.prawa = 4;
	elseif self.prawa > 4 then
		self.prawa = 0;
	end;
	
	self.zasieg = self.fillLevel / 200;	

	if self.isTurnedOn then	
	if self.lewa == 4 then
		self.translationMax1 =  false;
		self.translationMax2 =  false;
		self.translationMax3 =  false;
		self.translationMax4 =  false;
		if self.cuttingAreasBow[9] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[9].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[9].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[9].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.lewa == 3 then
		self.translationMax1 =  true;
		self.translationMax2 =  false;
		self.translationMax3 =  false;
		self.translationMax4 =  false;
		if self.cuttingAreasBow[8] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[8].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[8].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[8].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.lewa == 2 then
		self.translationMax1 =  true;
		self.translationMax2 =  true;
		self.translationMax3 =  false;
		self.translationMax4 =  false;
		if self.cuttingAreasBow[7] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[7].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[7].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[7].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.lewa == 1 then
		self.translationMax1 =  true;
		self.translationMax2 =  true;
		self.translationMax3 =  true;
		self.translationMax4 =  false;
		if self.cuttingAreasBow[6] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[6].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[6].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[6].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.lewa == 0 then
		self.translationMax1 =  true;
		self.translationMax2 =  true;
		self.translationMax3 =  true;
		self.translationMax4 =  true;	
		if self.cuttingAreasBow[1] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[1].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[1].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[1].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	end;

	if self.prawa == 4 then
		self.translationMax5 =  false;
		self.translationMax6 =  false;
		self.translationMax7 =  false;
		self.translationMax8 =  false;
		if self.cuttingAreasBow[5] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[5].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[5].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[5].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.prawa == 3 then
		self.translationMax5 =  true;
		self.translationMax6 =  false;
		self.translationMax7 =  false;
		self.translationMax8 =  false;
		if self.cuttingAreasBow[4] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[4].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[4].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[4].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.prawa == 2 then
		self.translationMax5 =  true;
		self.translationMax6 =  true;
		self.translationMax7 =  false;
		self.translationMax8 =  false;
		if self.cuttingAreasBow[3] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[3].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[3].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[3].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.prawa == 1 then
		self.translationMax5 =  true;
		self.translationMax6 =  true;
		self.translationMax7 =  true;
		self.translationMax8 =  false;
		if self.cuttingAreasBow[2] ~= nil then
		local x,y,z = getWorldTranslation(self.cuttingAreasBow[2].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[2].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[2].height);	
		Utils.updateSprayArea(x, z, x1, z1, x2, z2);
		end;
	elseif self.prawa == 0 then
		self.translationMax5 =  true;
		self.translationMax6 =  true;
		self.translationMax7 =  true;
		self.translationMax8 =  true;	
	end;

	if self.translationMax1 ~= nil then
        local x, y, z = getTranslation(self.translationPart1.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart1.maxTrans, self.translationPart1.minTrans, 3, self.translationPart1.transTime, dt, not self.translationMax1);
        setTranslation(self.translationPart1.node, unpack(newTrans));
	end;
	if self.translationMax2 ~= nil then
        local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
	end;
	if self.translationMax3 ~= nil then
        local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
	if self.translationMax4 ~= nil then
        local x, y, z = getTranslation(self.translationPart4.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart4.maxTrans, self.translationPart4.minTrans, 3, self.translationPart4.transTime, dt, not self.translationMax4);
        setTranslation(self.translationPart4.node, unpack(newTrans));
	end;
	if self.translationMax5 ~= nil then
        local x, y, z = getTranslation(self.translationPart5.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart5.maxTrans, self.translationPart5.minTrans, 3, self.translationPart5.transTime, dt, not self.translationMax5);
        setTranslation(self.translationPart5.node, unpack(newTrans));
	end;
	if self.translationMax6 ~= nil then
        local x, y, z = getTranslation(self.translationPart6.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart6.maxTrans, self.translationPart6.minTrans, 3, self.translationPart6.transTime, dt, not self.translationMax6);
        setTranslation(self.translationPart6.node, unpack(newTrans));
	end;
	if self.translationMax7 ~= nil then
        local x, y, z = getTranslation(self.translationPart7.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart7.maxTrans, self.translationPart7.minTrans, 3, self.translationPart7.transTime, dt, not self.translationMax7);
        setTranslation(self.translationPart7.node, unpack(newTrans));
	end;
	if self.translationMax8 ~= nil then
        local x, y, z = getTranslation(self.translationPart8.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart8.maxTrans, self.translationPart8.minTrans, 3, self.translationPart8.transTime, dt, not self.translationMax8);
        setTranslation(self.translationPart8.node, unpack(newTrans));
	end;
	
		
	if self.attacherVehicle then
		self.szerokosc = 2 + (self.lewa * 4.75) + (self.prawa * 4.75);
		if self.isTurnedOn then
			local literPercentage = self.literPerHa / 350;
			local widthPercentage = self.szerokosc/42; -- x/42
			local speedPercentage = math.max(1, ((self.lastSpeed * 3600) / 15));			
			self.sprayLitersPerSecond[self.currentFillType] = 6 * literPercentage * widthPercentage * speedPercentage;
		end;
	end;
		end;				
	end;
end;

function precyzyjna_dawka:draw()
	g_currentMission:addExtraPrintText(string.format("Amazone Manual: num 4"));

	if self.info then
		self.hud:render();
	end;
	
	self.ux_hud:render();
	if self.chemia then
	renderText(0.4352, 0.028, 0.01, string.format("Preparing: %0.1f",self.wymieszanie));
	else
	renderText(0.4352, 0.028, 0.01, string.format("Left area: %0.1f ha",self.zasieg));
	end;

	if self.chemia then
		if self.wymieszanie > 11.25 then
			self.ux4_True_hud:render();
		elseif self.wymieszanie > 22.5 then
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
		elseif self.wymieszanie > 33.75 then
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
		elseif self.wymieszanie > 45 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
		elseif self.wymieszanie > 56.25 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
			self.ux5_True_hud:render();
		elseif self.wymieszanie > 67.5 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();	
		elseif self.wymieszanie > 78.75 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();
			self.ux7_True_hud:render();
		elseif self.wymieszanie > 90 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();
			self.ux7_True_hud:render();
			self.ux8_True_hud:render();	
		end;
	else
		if self.lewa == 4 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();
			self.ux3_True_hud:render();
			self.ux4_True_hud:render();	
		elseif self.lewa == 3 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();	
			self.ux3_True_hud:render();
		elseif self.lewa == 2 then
			self.ux1_True_hud:render();
			self.ux2_True_hud:render();	
		elseif self.lewa == 1 then
			self.ux1_True_hud:render();	
		elseif self.lewa == 0 then
		end;
		
		if self.prawa == 4 then
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();
			self.ux7_True_hud:render();
			self.ux8_True_hud:render();	
		elseif self.prawa == 3 then
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();
			self.ux7_True_hud:render();
		elseif self.prawa == 2 then
			self.ux5_True_hud:render();
			self.ux6_True_hud:render();	
		elseif self.prawa == 1 then
			self.ux5_True_hud:render();
		elseif self.prawa == 0 then
		end;
	end;
end;

function precyzyjna_dawka:delete()
end;

function precyzyjna_dawka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function precyzyjna_dawka:skladanie()


	if self.lewabelkaAnimationName ~= "" then
        local animTime = nil;
        if self:getIsAnimationPlaying(self.lewabelkaAnimationName) then
			animTime = self:getAnimationTime(self.lewabelkaAnimationName);
        end;
        if self.lewastrona == false then
            self:playAnimation(self.lewabelkaAnimationName, self.lewabelkaAnimationLowerSpeed, animTime, true)
        else
            self:playAnimation(self.lewabelkaAnimationName, self.lewabelkaAnimationLiftSpeed, animTime, true)
        end;
	end;
	if self.prawabelkaAnimationName ~= "" then
        local animTime = nil;
        if self:getIsAnimationPlaying(self.prawabelkaAnimationName) then
			animTime = self:getAnimationTime(self.prawabelkaAnimationName);
        end;
        if self.prawastrona == false then
            self:playAnimation(self.prawabelkaAnimationName, self.prawabelkaAnimationLowerSpeed, animTime, true)
        else
            self:playAnimation(self.prawabelkaAnimationName, self.prawabelkaAnimationLiftSpeed, animTime, true)
        end;
	end;
	if self.chemiaAnimationName ~= "" then
        local animTime = nil;
        if self:getIsAnimationPlaying(self.chemiaAnimationName) then
			animTime = self:getAnimationTime(self.chemiaAnimationName);
        end;
        if self.chemia == true then
            self:playAnimation(self.chemiaAnimationName, self.chemiaAnimationLowerSpeed, animTime, true)
        else
            self:playAnimation(self.chemiaAnimationName, self.chemiaAnimationLiftSpeed, animTime, true)
        end;
	end;
end;

function precyzyjna_dawka:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_KP_4	then
		self.info = not self.info;
	end;
	if isDown and sym == Input.KEY_KP_7 then
		self.lewa = self.lewa - 1;
	end;
	if isDown and sym == Input.KEY_KP_8 then
		self.prawa = self.prawa - 1;
	end;
	if isDown and sym == Input.KEY_m then
		self.oproznianie = not self.oproznianie;
	end;
	if isDown and sym == Input.KEY_k then
		self.lewastrona = not self.lewastrona;
		self:skladanie();		
		self.lewa = 1;
	end;
	if isDown and sym == Input.KEY_l then
		self.prawastrona = not self.prawastrona;
		self:skladanie();	
		self.prawa = 1;		
	end;
	if isDown and sym == Input.KEY_z and not self.oproznianie then
		self.chemia = not self.chemia;
		self:skladanie();
	end;
end;