--
-- Autor: Siwus
-- Specialization for sprayer
--


poziomowanie = {};

function poziomowanie.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations) ;
	end;


function poziomowanie:load(xmlFile)
	self.groundCheck = {};
	self.groundCheck.left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#left"));
	self.groundCheck.right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#right"));

	self.wysokosc = {};
	self.wysokosc.belka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wysokoscbelki#belka"));
	self.wysokosc.podloze = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wysokoscbelki#podloze"));

	local rotationPartNodeRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 100)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
	
	
	local rotationPartNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 100)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
	self.rotationMaxRight = true;
	self.rotationMaxLeft = true;
end;


function poziomowanie:update(dt)

	if self.attacherVehicle then
		if self.isTurnedOn then
			local x,y,z = getWorldTranslation(self.groundCheck.right);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCr = y-terrainHeight; 
			self.wysokoscP = y-terrainHeight;
			
			local x,y,z = getWorldTranslation(self.groundCheck.left);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCl = y-terrainHeight; 
--			local gC = math.floor(math.min(gCl,gCr) * 40) / 10;
			self.wysokoscL = y-terrainHeight;
			
			if self.wysokoscP < 0 then
				self.rotationMaxRight = true;
			else
				self.rotationMaxRight = false;
			end;
			
			if self.wysokoscL < -0.5 then
				self.rotationMaxLeft = true;
			else
				self.rotationMaxLeft = false;
			end;

--			if (gC < 2.0) then
--			else
--			end;
		end;
			local x,y,z = getWorldTranslation(self.wysokosc.belka);
			local a,b,c = getWorldTranslation(self.wysokosc.podloze);
			self.wysokoscbelki = y-b;
		
	end;

	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;

end;

function poziomowanie:draw()
	g_currentMission:addExtraPrintText(string.format("Wysokosc belki: %0.2f ",self.wysokoscbelki));
end;

function poziomowanie:delete()
end;

function poziomowanie:mouseEvent(posX, posY, isDown, isUp, button)
end;

function poziomowanie:keyEvent(unicode, sym, modifier, isDown)
end;