--
-- Fuchs Guellefass
-- Class for the Fuchs Guellefass
--
-- @author  Stefan Maurus - www.stefanmaurus.de
-- @date  20.08.2012
-- @last edit 09.02.2013
--
FuchsGuellefass = {};
  
function FuchsGuellefass.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function FuchsGuellefass:load(xmlFile)
		
	-- Fuellstandsanzeiger 
	self.Zeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zeiger#index"));	
	self.ZeigerMin =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMax"));	
	self.ZeigerMax =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMin"));	
	self.ZeigerAchse = getXMLString(xmlFile, "vehicle.Zeiger#rotationAchse");
	self.XAchse = "x";
	self.YAchse = "y";
	self.ZAchse = "z";
	self.PositiveZahl = false;
	self.NegativeZahl = false;
	self.ZeigerRotationNew = 0;

end;
 
function FuchsGuellefass:update(dt)
	local rx, ry, rz = getRotation(self.Zeiger)
	local unterschiedMinMax = self.ZeigerMax - self.ZeigerMin; 
	if unterschiedMinMax > 0 then
		self.PositiveZahl = true;
		self.NegativeZahl = false;		
	else
		self.NegativeZahl = true;
		self.PositiveZahl = false;
	end;	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)
	local RotationStep = unterschiedMinMax / 100; 
	local ZeigerRotation = fillLevelPerCent * RotationStep; 
	local ZeigerRotationRad = math.rad(ZeigerRotation); 
	if self.PositiveZahl == true and self.NegativeZahl == false then
		self.ZeigerRotationNew = ZeigerRotationRad * -1;
	elseif self.PositiveZahl == false and self.NegativeZahl == true then
		self.ZeigerRotationNew = ZeigerRotationRad * 1;	
	end;
	if self.ZeigerAchse == self.XAchse then
		setRotation(self.Zeiger, self.ZeigerRotationNew, ry, rz)
	elseif self.ZeigerAchse == self.YAchse then
		setRotation(self.Zeiger, rx, self.ZeigerRotationNew, rz)	
	elseif self.ZeigerAchse == self.ZAchse then
		setRotation(self.Zeiger, rx, ry, self.ZeigerRotationNew)	
	end;	
end;