--
-- opryskiwacz
-- Specialization for opryskiwacz
--
-- @author Felix "Outlaw" Sorge
-- @date  25/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

opryskiwacz = {};

function opryskiwacz.prerequisitesPresent(specializations)
    return true;
	end;


function opryskiwacz:load(xmlFile)
    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
     if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
     if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
     end;
	 
	 local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
     if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
     end;

     local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
     if rotationPartNode3 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
     end;
	 
	 local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
     if rotationPartNode4 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
     end;

	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;

	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.workLights.workLight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsActive = false;

	local numwezes = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wezes#count"), 0);
    self.wezes = {};
    for i=1, numwezes do
        local wezenamei = string.format("vehicle.wezes.weze%d", i);
        self.wezes[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, wezenamei .. "#index"));
        setVisibility(self.wezes[i], false);
    end;
	self.wezesActive = false;

	self.sprayParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems.sprayParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

	self.sprayParticleSystems1 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems1.sprayParticleSystems1(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems1, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

		self.sprayParticleSystems2 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems2.sprayParticleSystems2(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems2, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

		self.sprayParticleSystems3 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems3.sprayParticleSystems3(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems3, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

	self.sprayParticleSystems4 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems4.sprayParticleSystems4(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems4, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
		self.sprayParticleSystems5 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems5.sprayParticleSystems5(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems5, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;

	local numCuttingAreasBow = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreasBow#count"), 0);
	self.cuttingAreasBow = {};
    for i=1, numCuttingAreasBow do
        self.cuttingAreasBow[i] = {};
        local areanamei = string.format("vehicle.cuttingAreasBow.cuttingArea%d", i);
        self.cuttingAreasBow[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasBow[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasBow[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
	self.literPerHa = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerHa#value"), 1);
	self.heightPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.heightPoint#node"));
	self.heightPoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.heightPoint2#node"));

	self.groundCheck = {};
	self.groundCheck.left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#left"));
	self.groundCheck.right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#right"));
	
	self.levelCheck = false;
	self.turnon = false;
	self.sekcja1 = true;
	self.sekcja2 = true;
	self.sekcja3 = true;
	self.sekcja4 = true;
	
end;


function opryskiwacz:update(dt)

	
	
	if self.praca then
			self.rotationMax = true;
			self.rotationMax2 = true;
			self.rotationMax3 = true;
			self.rotationMax4 = true;
			self.rotationMax5 = true;
			self.rotationMax6 = true;
	else
			self.rotationMax = false;
			self.rotationMax2 = false;
			self.rotationMax3 = false;
			self.rotationMax4 = false;
			self.rotationMax5 = false;
			self.rotationMax6 = false;
	end;

		for k, weze in pairs(self.wezes) do
			setVisibility(weze, self.wezesActive);
		end;
		
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsActive);
		end;

		if self.levelCheck then	
			local x,y,z = getWorldTranslation(self.groundCheck.right);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCr = y-terrainHeight; 
			local x,y,z = getWorldTranslation(self.groundCheck.left);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCl = y-terrainHeight; 
			local gC = math.floor(math.min(gCl,gCr) * 40) / 10;
			if (gC < 2.0) then 
				self.translationMax = true;
			else
				self.translationMin = true;
			end;
		end; 		

	if self.turnon then
				if self.cuttingAreasBow[1] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[1].height);		
					Utils.updateSprayArea(x, z, x1, z1, x2, z2);
				end;
				
				if self.sekcja1 then
					if self.cuttingAreasBow[2] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[2].height);		
					Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					end;
					self.belka1 = 5.5;
					Utils.setEmittingState(self.sprayParticleSystems1, true)			
				else
					self.belka1 = 0;
					Utils.setEmittingState(self.sprayParticleSystems1, false)			
				end;

				if self.sekcja2 then
					if self.cuttingAreasBow[3] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[3].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[3].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[3].height);		
					Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					end;
					Utils.setEmittingState(self.sprayParticleSystems2, true)			
					self.belka2 = 5.5;
				else
					self.belka2 = 0;
					Utils.setEmittingState(self.sprayParticleSystems2, false)			
				end;
				
				if self.sekcja3 then
					if self.cuttingAreasBow[4] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[4].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[4].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[4].height);		
					Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					end;
					self.belka3 = 5.5;
					Utils.setEmittingState(self.sprayParticleSystems3, true)			
				else
					self.belka3 = 0;
					Utils.setEmittingState(self.sprayParticleSystems3, false)			
				end;
				
				if self.sekcja4 then
					if self.cuttingAreasBow[5] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[5].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[5].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[5].height);		
					Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					end;
					self.belka4 = 5.5;
					Utils.setEmittingState(self.sprayParticleSystems4, true)
				else
					self.belka4 = 0;
					Utils.setEmittingState(self.sprayParticleSystems4, false)			
				end;
				
			local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			local usage = self.literPerHa*(self.belka1 + self.belka2 + self.belka3 + self.belka4 + 2)*0.0000005*(self.lastSpeed*3600);
			self:setFillLevel(self.fillLevel-usage, self.currentFillType);
			Utils.setEmittingState(self.sprayParticleSystems, true)			

	end;
				
	if not self.turnon then
				Utils.setEmittingState(self.sprayParticleSystems, false)			
				Utils.setEmittingState(self.sprayParticleSystems1, false)			
				Utils.setEmittingState(self.sprayParticleSystems2, false)			
				Utils.setEmittingState(self.sprayParticleSystems3, false)			
				Utils.setEmittingState(self.sprayParticleSystems4, false)			
	end;

			if self.wezesActive then
				Utils.setEmittingState(self.sprayParticleSystems, false)			
				Utils.setEmittingState(self.sprayParticleSystems1, false)			
				Utils.setEmittingState(self.sprayParticleSystems2, false)			
				Utils.setEmittingState(self.sprayParticleSystems3, false)			
				Utils.setEmittingState(self.sprayParticleSystems4, false)			
			end;
			
		if self.rotationPart ~= nil then
          local x, y, z = getRotation(self.rotationPart.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart.node, unpack(newRot));
        end;
        
        if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart2.node, unpack(newRot));
        end;
        
        if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart3.node, unpack(newRot));
        end;
		
		if self.rotationPart4 ~= nil then
          local x, y, z = getRotation(self.rotationPart4.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart4.node, unpack(newRot));
        end;

		 if self.rotationPart5 ~= nil then
          local x, y, z = getRotation(self.rotationPart5.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart5.node, unpack(newRot));
        end;
		
		if self.rotationPart6 ~= nil then
          local x, y, z = getRotation(self.rotationPart6.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart6.node, unpack(newRot));
        end;

	local doTranslate = self.translationMax or self.translationMin 
	if self.translationPart ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax); 
		setTranslation(self.translationPart.node, unpack(newTrans)); 
	end; 
	
	local x5,y5,z5 = getWorldTranslation(self.heightPoint);
	local x6,y6,z6 = getWorldTranslation(self.heightPoint2);	
	self.differenz = 2.5+y5-y6; 
	
	self.powierzchnia = self.fillLevel/self.literPerHa;
	
	if self.fillLevel <= 0 then
		self.turnon = false;
	end;

end;

function opryskiwacz:draw()
		g_currentMission:addExtraPrintText(string.format("Wysokosc: %0.2fm",self.differenz));
		g_currentMission:addExtraPrintText(string.format("Ciecz robocza na %0.2fha",self.powierzchnia));
end;


function opryskiwacz:onAttach()
end; 	


function opryskiwacz:onDetach()
end;


function opryskiwacz:delete()
end;


function opryskiwacz:mouseEvent(posX, posY, isDown, isUp, button)
end;


function opryskiwacz:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_x then
		self.praca = not self.praca;
	end;
    if sym == Input.KEY_KP_9 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationMin = isDown;
	end;
	if isDown and sym == Input.KEY_z then
		self.wezesActive = not self.wezesActive;
	end;
	if isDown and sym == Input.KEY_KP_3 then
		self.sekcja1 = not self.sekcja1;
	end;
	if isDown and sym == Input.KEY_KP_enter then
		self.sekcja2 = not self.sekcja2;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.sekcja3 = not self.sekcja3;
	end;
	if isDown and sym == Input.KEY_KP_1 then
		self.sekcja4 = not self.sekcja4;
	end;
	if isDown and sym == Input.KEY_m then
		self.turnon = not self.turnon;
	end;
	if isDown and sym == Input.KEY_n then
		self.workLightsActive = not self.workLightsActive;
	end;
	if isDown and sym == Input.KEY_o then
		self.levelCheck = not self.levelCheck;
	end;

end;

function opryskiwacz:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
  if not resetVehicles then
	local roboczy = getXMLBool(xmlFile, key.."#roboczy");
	if roboczy then
	   self.praca = true;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
 end;
end;

function opryskiwacz:getSaveAttributesAndNodes(nodeIdent)
   local attributes = 'roboczy="'..tostring(self.praca)..'"';
   return attributes, nil;
end;
