--
-- 
-- Autor: Siwus
--

Cayena = {};

function Cayena.prerequisitesPresent(specializations)
    return true;
end;

function Cayena:load(xmlFile)
	local numCuttingAreasBow = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreasBow#count"), 0);
	self.cuttingAreasBow = {};
    for i=1, numCuttingAreasBow do
        self.cuttingAreasBow[i] = {};
        local areanamei = string.format("vehicle.cuttingAreasBow.cuttingArea%d", i);
        self.cuttingAreasBow[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasBow[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasBow[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;

	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
	self.rotationMaxLeft = true;
	self.znaczniki = true;

end;

function Cayena:delete()
end;

function Cayena:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cayena:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_n then
		self.znaczniki = not self.znaczniki;
		self.rotationMaxLeft = not self.rotationMaxLeft;
	end;
end;

function Cayena:update(dt)	
	if self.attacherVehicle then
		if not self.znaczniki then
			if self.cuttingAreasBow[2] ~= nil then
				local x,y,z = getWorldTranslation(self.cuttingAreasBow[2].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[2].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[2].height);	
				Utils.updateCultivatorArea(x, z, x1, z1, x2, z2)
			end;	
			if self.cuttingAreasBow[1] ~= nil then
				local x,y,z = getWorldTranslation(self.cuttingAreasBow[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[1].height);		
				Utils.updateCultivatorArea(x, z, x1, z1, x2, z2)
			end;
		end;
	end;
    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;	

end;


function Cayena:draw()
	if not self.znaczniki then
		g_currentMission:addExtraPrintText(string.format("Wlacz sciezki technologiczne: N"));
	else
		g_currentMission:addExtraPrintText(string.format("Wylacz sciezki technologiczne: N"));
	end;
end;


function Cayena:onAttach(attacherVehicle)
end;


function Cayena:onDetach()
end;


function Cayena:onLeave()
end;


function Cayena:onDeactivate()
end;


function Cayena:onDeactivateSounds()
end;
