-- pestilloalas
-- Specializacion para Amazone Catros 9000T/12000T
--
-- @ Autor  Javier007 (Big Boos Modding)

pestilloalas = {};

function pestilloalas.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function pestilloalas:load(xmlFile)	
	self.updateJoint = false;
	self.aiTerrainDetailChannelBackUp1 = nil;
	self.aiTerrainDetailChannelBackUp2 = nil;	
	self.aiLeftMarkerBackUp = self.aiLeftMarker;
    self.aiRightMarkerBackUp = self.aiRightMarker;
    self.aiBackMarkerBackUp = self.aiBackMarker;	
	self.setTerrainDetailChannels = false;
	self.aiActiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hitchMoveTime#aiActiveSpeedMultiplicator"), 1);
	self.aiDeactiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hitchMoveTime#aiDeactiveSpeedMultiplicator"), 1);
	self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
end;

function pestilloalas:delete()
end;

function pestilloalas:readStream(streamId, connection)
end;

function pestilloalas:writeStream(streamId, connection)	
end;

function pestilloalas:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pestilloalas:keyEvent(unicode, sym, modifier, isDown)
end;

function pestilloalas:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.QUITAR_PESTILLO_ALAS) then
			if self:getRealAnimationTime("pestilloalas") > 750 then
				self:playAnimation("pestilloalas", -1, nil);
			elseif self:getRealAnimationTime("pestilloalas") < 750 then
				self:playAnimation("pestilloalas", 1, nil);				
			end;
		end;
	end;
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
end;

function pestilloalas:updateTick(dt)
	if self.setTerrainDetailChannels then
		if table.getn(self.attachedImplements) > 0 then
			for k,implement in pairs(self.attachedImplements) do
				if implement.object.aiTerrainDetailChannel1 ~= nil and implement.object.aiTerrainDetailChannel2 ~= nil and implement.object.aiLeftMarker ~= nil and implement.object.aiRightMarker ~= nil and implement.object.aiBackMarker ~= nil then
					self.aiTerrainDetailChannelBackUp1 = self.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannelBackUp2 = self.aiTerrainDetailChannel2;
					self.aiTerrainDetailChannel1 = implement.object.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannel2 = implement.object.aiTerrainDetailChannel2;
					self.aiLeftMarker = implement.object.aiLeftMarker;
					self.aiRightMarker = implement.object.aiRightMarker;
					self.aiBackMarker = implement.object.aiBackMarker;
				end;
			end;
		else
			if self.aiTerrainDetailChannelBackUp1 ~= nil and self.aiTerrainDetailChannelBackUp2 ~= nil and self.aiLeftMarkerBackUp ~= nil and self.aiRightMarkerBackUp ~= nil and self.aiBackMarkerBackUp ~= nil then
				self.aiTerrainDetailChannel1 = self.aiTerrainDetailChannelBackUp1;
				self.aiTerrainDetailChannel2 = self.aiTerrainDetailChannelBackUp2;
				self.aiTerrainDetailChannelBackUp1 = nil;
				self.aiTerrainDetailChannelBackUp2 = nil;
				self.aiLeftMarker = self.aiLeftMarkerBackUp;
				self.aiRightMarker = self.aiRightMarkerBackUp;
				self.aiBackMarker = self.aiBackMarkerBackUp;
			end;
		end;
		self.setTerrainDetailChannels = false;
	end;
	if self:getIsActive() then
		self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
		self.updateJoint = true;
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.isHired ~= nil then
				self.currentLiftSpeed = self.aiActiveSpeedMultiplicator;
			end;
			if self.attacherVehicle.isHired and table.getn(self.attachedImplements) > 0 then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					if implement.object == self then
						if self.attacherVehicle.attacherJoints[implement.jointDescIndex].moveDown then
							self:playAnimation("pestilloalas", -1*self.currentLiftSpeed, nil);
						else
							self:playAnimation("pestilloalas", 1*self.currentLiftSpeed, nil);
						end;
					end;
				end;
			end;
		end;		
	end;
end;

function pestilloalas:draw()
	if self:getRealAnimationTime("pestilloalas") > 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("PONER_PESTILLO_ALAS"), InputBinding.QUITAR_PESTILLO_ALAS);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("QUITAR_PESTILLO_ALAS"), InputBinding.QUITAR_PESTILLO_ALAS);
	end;
end;

function pestilloalas:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function pestilloalas:getSaveAttributesAndNodes(nodeIdent)
end;

function pestilloalas:aiTurnOn()
	self.isTurnedOn = true;
end;

function pestilloalas:aiTurnOff()
	self.isTurnedOn = false;
end;

function pestilloalas:detachImplement(implementIndex)
	self:playAnimation("pestilloalas", -1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function pestilloalas:attachImplement(implement)
	self:playAnimation("pestilloalas", 1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function pestilloalas:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;