-- aladerecha
-- Specializacion para Amazone Catros 9000T/12000T
--
-- @ Autor  Javier007 (Big Boos Modding)

aladerecha = {};

function aladerecha.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function aladerecha:load(xmlFile)	
	self.updateJoint = true;
	self.aiTerrainDetailChannelBackUp1 = nil;
	self.aiTerrainDetailChannelBackUp2 = nil;	
	self.aiLeftMarkerBackUp = self.aiLeftMarker;
    self.aiRightMarkerBackUp = self.aiRightMarker;
    self.aiBackMarkerBackUp = self.aiBackMarker;	
	self.setTerrainDetailChannels = false;
	self.aiActiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hitchMoveTime#aiActiveSpeedMultiplicator"), 1);
	self.aiDeactiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hitchMoveTime#aiDeactiveSpeedMultiplicator"), 1);
	self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
end;

function aladerecha:delete()
end;

function aladerecha:readStream(streamId, connection)
end;

function aladerecha:writeStream(streamId, connection)	
end;

function aladerecha:mouseEvent(posX, posY, isDown, isUp, button)
end;

function aladerecha:keyEvent(unicode, sym, modifier, isDown)
end;

function aladerecha:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.DESPLEGAR_ALA_DERECHA) then
			if self:getRealAnimationTime("aladerecha") > 750 then
				self:playAnimation("aladerecha", -1, nil);
			elseif self:getRealAnimationTime("aladerecha") < 750 then
				self:playAnimation("aladerecha", 1, nil);				
			end;
		end;
	end;
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
end;

function aladerecha:updateTick(dt)
	if self.setTerrainDetailChannels then
		if table.getn(self.attachedImplements) > 0 then
			for k,implement in pairs(self.attachedImplements) do
				if implement.object.aiTerrainDetailChannel1 ~= nil and implement.object.aiTerrainDetailChannel2 ~= nil and implement.object.aiLeftMarker ~= nil and implement.object.aiRightMarker ~= nil and implement.object.aiBackMarker ~= nil then
					self.aiTerrainDetailChannelBackUp1 = self.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannelBackUp2 = self.aiTerrainDetailChannel2;
					self.aiTerrainDetailChannel1 = implement.object.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannel2 = implement.object.aiTerrainDetailChannel2;
					self.aiLeftMarker = implement.object.aiLeftMarker;
					self.aiRightMarker = implement.object.aiRightMarker;
					self.aiBackMarker = implement.object.aiBackMarker;
				end;
			end;
		else
			if self.aiTerrainDetailChannelBackUp1 ~= nil and self.aiTerrainDetailChannelBackUp2 ~= nil and self.aiLeftMarkerBackUp ~= nil and self.aiRightMarkerBackUp ~= nil and self.aiBackMarkerBackUp ~= nil then
				self.aiTerrainDetailChannel1 = self.aiTerrainDetailChannelBackUp1;
				self.aiTerrainDetailChannel2 = self.aiTerrainDetailChannelBackUp2;
				self.aiTerrainDetailChannelBackUp1 = nil;
				self.aiTerrainDetailChannelBackUp2 = nil;
				self.aiLeftMarker = self.aiLeftMarkerBackUp;
				self.aiRightMarker = self.aiRightMarkerBackUp;
				self.aiBackMarker = self.aiBackMarkerBackUp;
			end;
		end;
		self.setTerrainDetailChannels = false;
	end;
	if self:getIsActive() then
		self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
		self.updateJoint = true;
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.isHired ~= nil then
				self.currentLiftSpeed = self.aiActiveSpeedMultiplicator;
			end;
			if self.attacherVehicle.isHired and table.getn(self.attachedImplements) > 0 then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					if implement.object == self then
						if self.attacherVehicle.attacherJoints[implement.jointDescIndex].moveDown then
							self:playAnimation("aladerecha", -1*self.currentLiftSpeed, nil);
						else
							self:playAnimation("aladerecha", 1*self.currentLiftSpeed, nil);
						end;
					end;
				end;
			end;
		end;		
	end;
end;

function aladerecha:draw()
	if self:getRealAnimationTime("aladerecha") > 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("PLEGAR_ALA_DERECHA"), InputBinding.DESPLEGAR_ALA_DERECHA);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("DESPLEGAR_ALA_DERECHA"), InputBinding.DESPLEGAR_ALA_DERECHA);
	end;
end;

function aladerecha:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function aladerecha:getSaveAttributesAndNodes(nodeIdent)
end;

function aladerecha:aiTurnOn()
	self.isTurnedOn = true;
end;

function aladerecha:aiTurnOff()
	self.isTurnedOn = false;
end;

function aladerecha:detachImplement(implementIndex)
	self:playAnimation("aladerecha", -1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function aladerecha:attachImplement(implement)
	self:playAnimation("aladerecha", 1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function aladerecha:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = true;
        return true;
    end;
    return true;
end;