--
-- Autor: Siwus
-- Specialization for sprayer
--


precyzyjna_dawka_rozsiewacz = {};

function precyzyjna_dawka_rozsiewacz.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations) ;
	end;


function precyzyjna_dawka_rozsiewacz:load(xmlFile)
	self.literPerHa = 200;
end;


function precyzyjna_dawka_rozsiewacz:update(dt)

	if self.attacherVehicle then
		if self.isTurnedOn then
			local literPercentage = self.literPerHa / 350;
			local widthPercentage = 0.857; -- x/42
			local speedPercentage = math.max(1, ((self.lastSpeed * 3600) / 15));			
			self.sprayLitersPerSecond[self.currentFillType] = 6 * literPercentage * widthPercentage * speedPercentage;
		end;
	end;	
end;

function precyzyjna_dawka_rozsiewacz:draw()
	g_currentMission:addExtraPrintText(string.format("Dawka: %0.1fha;   Num 5/8",self.literPerHa));
end;

function precyzyjna_dawka_rozsiewacz:delete()
end;

function precyzyjna_dawka_rozsiewacz:mouseEvent(posX, posY, isDown, isUp, button)
end;

function precyzyjna_dawka_rozsiewacz:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_8 then
		self.literPerHa = self.literPerHa + 10;
	end;
	if isDown and sym == Input.KEY_KP_5 then
		self.literPerHa = self.literPerHa - 10;
	end;	
end;